/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.util.IntPair;
import twilightforest.world.ChunkGeneratorTwilightBase;
import twilightforest.world.TFDimensions;
import twilightforest.worldgen.biomes.BiomeKeys;

public class ChunkGeneratorTwilightForest
extends ChunkGeneratorTwilightBase {
    public static final Codec<ChunkGeneratorTwilightForest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(ChunkGenerator::func_202090_b), (App)Codec.LONG.fieldOf("seed").stable().orElseGet(() -> TFDimensions.seed).forGetter(obj -> obj.seed), (App)DimensionSettings.field_236098_b_.fieldOf("settings").forGetter(ChunkGeneratorTwilightForest::getDimensionSettings)).apply((Applicative)instance, instance.stable(ChunkGeneratorTwilightForest::new)));
    private long seed;

    public ChunkGeneratorTwilightForest(BiomeProvider provider, long seed, Supplier<DimensionSettings> settings) {
        super(provider, seed, settings, true);
        this.seed = seed;
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    public ChunkGenerator func_230349_a_(long l) {
        return new ChunkGeneratorTwilightForest(this.field_222542_c.func_230320_a_(l), l, this.dimensionSettings);
    }

    private Supplier<DimensionSettings> getDimensionSettings() {
        return this.dimensionSettings;
    }

    public void func_230352_b_(IWorld world, StructureManager p_230352_2_, IChunk chunk) {
        super.func_230352_b_(world, p_230352_2_, chunk);
        if (!(world instanceof WorldGenRegion)) {
            return;
        }
        WorldGenRegion primer = (WorldGenRegion)world;
        this.addDarkForestCanopy2(primer);
        this.addGlaciers(primer);
        this.deformTerrainForFeature(primer);
    }

    private void addGlaciers(WorldGenRegion primer) {
        BlockState glacierBase = Blocks.field_150351_n.func_176223_P();
        BlockState glacierMain = (Boolean)TFConfig.COMMON_CONFIG.PERFORMANCE.glacierPackedIce.get() != false ? Blocks.field_150403_cj.func_176223_P() : Blocks.field_150432_aD.func_176223_P();
        BlockState glacierTop = Blocks.field_150432_aD.func_176223_P();
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                Biome biome = primer.func_226691_t_(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z));
                if (!BiomeKeys.GLACIER.func_240901_a_().equals((Object)biome.getRegistryName())) continue;
                int gBase = -1;
                for (int y = 127; y >= 0; --y) {
                    Block currentBlock = primer.func_180495_p(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y)).func_177230_c();
                    if (currentBlock != Blocks.field_150348_b) continue;
                    gBase = y + 1;
                    primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y), glacierBase, 3);
                    break;
                }
                int gHeight = 32;
                int gTop = Math.min(gBase + gHeight, 127);
                for (int y = gBase; y < gTop; ++y) {
                    primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y), glacierMain, 3);
                }
                primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), gTop), glacierTop, 3);
            }
        }
    }

    private void addDarkForestCanopy2(WorldGenRegion primer) {
        BlockPos blockpos = this.getPos(primer).func_206849_h();
        int[] thicks = new int[25];
        boolean biomeFound = false;
        for (int z = 0; z < 5; ++z) {
            for (int x = 0; x < 5; ++x) {
                for (int bx = -1; bx <= 1; ++bx) {
                    for (int bz = -1; bz <= 1; ++bz) {
                        BlockPos p = blockpos.func_177982_a(x + bx << 2, 0, z + bz << 2);
                        Biome biome = this.field_222542_c.func_225526_b_(p.func_177958_n() >> 2, 0, p.func_177952_p() >> 2);
                        if (!BiomeKeys.DARK_FOREST.func_240901_a_().equals((Object)biome.getRegistryName()) && !BiomeKeys.DARK_FOREST_CENTER.func_240901_a_().equals((Object)biome.getRegistryName())) continue;
                        int n = x + z * 5;
                        thicks[n] = thicks[n] + 1;
                        biomeFound = true;
                    }
                }
            }
        }
        if (!biomeFound) {
            return;
        }
        IntPair nearCenter = new IntPair();
        TFFeature nearFeature = TFFeature.getNearestFeature(this.getPos((WorldGenRegion)primer).field_77276_a, this.getPos((WorldGenRegion)primer).field_77275_b, (ISeedReader)primer, nearCenter);
        double d = 0.03125;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                Block currentBlock;
                int hz;
                int rz;
                int hx;
                int rx;
                int dist;
                int qx = x / 4;
                int qz = z / 4;
                float xweight = (float)(x % 4) * 0.25f + 0.125f;
                float zweight = (float)(z % 4) * 0.25f + 0.125f;
                float thickness = 0.0f;
                thickness += (float)thicks[qx + qz * 5] * (1.0f - xweight) * (1.0f - zweight);
                thickness += (float)thicks[qx + 1 + qz * 5] * xweight * (1.0f - zweight);
                thickness += (float)thicks[qx + (qz + 1) * 5] * (1.0f - xweight) * zweight;
                thickness += (float)thicks[qx + 1 + (qz + 1) * 5] * xweight * zweight;
                thickness -= 4.0f;
                if (nearFeature == TFFeature.DARK_TOWER && (dist = (int)Math.sqrt((rx = x - (hx = nearCenter.x)) * rx + (rz = z - (hz = nearCenter.z)) * rz)) < 24) {
                    thickness -= (float)(24 - dist);
                }
                if (!(thickness > 1.0f)) continue;
                int topLevel = -1;
                for (int y = 127; y >= 0 && (currentBlock = primer.func_180495_p(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y)).func_177230_c()) != Blocks.field_150355_j; --y) {
                    if (currentBlock != Blocks.field_150348_b) continue;
                    topLevel = y;
                    break;
                }
                if (topLevel == -1) continue;
                int noise = Math.min(3, (int)(this.field_222571_r.func_215460_a((double)(blockpos.func_177958_n() + x) * 0.0625, (double)(blockpos.func_177952_p() + z) * 0.0625, 0.0625, (double)x * 0.0625) * 15.0 / 1.25));
                int treeBottom = topLevel + 12 - (int)(thickness * 0.5f);
                int treeTop = treeBottom + (int)(thickness * 1.5f);
                BlockState darkLeaves = ((Block)TFBlocks.dark_leaves.get()).func_176223_P();
                for (int y = treeBottom -= noise; y < treeTop; ++y) {
                    primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y), darkLeaves, 3);
                }
            }
        }
    }
}

