/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.stronghold;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.stronghold.StrongholdEntranceComponent;
import twilightforest.structures.stronghold.StrongholdPieces;
import twilightforest.structures.stronghold.StrongholdUpperAscenderComponent;
import twilightforest.structures.stronghold.StrongholdUpperCorridorComponent;
import twilightforest.structures.stronghold.StrongholdUpperLeftTurnComponent;
import twilightforest.structures.stronghold.StrongholdUpperRightTurnComponent;
import twilightforest.structures.stronghold.StrongholdUpperTIntersectionComponent;

public abstract class StructureTFStrongholdComponent
extends TFStructureComponentOld {
    public List<BlockPos> doors = new ArrayList<BlockPos>();

    public StructureTFStrongholdComponent(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
        this.readOpeningsFromArray(nbt.func_74759_k("doorInts"));
    }

    public StructureTFStrongholdComponent(IStructurePieceType type, TFFeature feature, int i, Direction facing, int x, int y, int z) {
        super(type, feature, i);
        this.field_74887_e = this.generateBoundingBox(facing, x, y, z);
        this.func_186164_a(facing);
    }

    private int[] getDoorsAsIntArray() {
        IntBuffer ibuffer = IntBuffer.allocate(this.doors.size() * 3);
        for (BlockPos door : this.doors) {
            ibuffer.put(door.func_177958_n());
            ibuffer.put(door.func_177956_o());
            ibuffer.put(door.func_177952_p());
        }
        return ibuffer.array();
    }

    @Override
    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74783_a("doorInts", this.getDoorsAsIntArray());
    }

    private void readOpeningsFromArray(int[] intArray) {
        for (int i = 0; i < intArray.length; i += 3) {
            BlockPos door = new BlockPos(intArray[i], intArray[i + 1], intArray[i + 2]);
            this.doors.add(door);
        }
    }

    public abstract MutableBoundingBox generateBoundingBox(Direction var1, int var2, int var3, int var4);

    public static MutableBoundingBox getComponentToAddBoundingBox(int x, int y, int z, int xOff, int yOff, int zOff, int xSize, int ySize, int zSize, Direction facing) {
        switch (facing) {
            case WEST: {
                return new MutableBoundingBox(x - zSize + 1 + zOff, y + yOff, z + xOff, x + zOff, y + ySize - 1 + yOff, z + xSize - 1 + xOff);
            }
            case NORTH: {
                return new MutableBoundingBox(x - xSize + 1 - xOff, y + yOff, z - zSize + 1 + zOff, x - xOff, y + ySize - 1 + yOff, z + zOff);
            }
            case EAST: {
                return new MutableBoundingBox(x + zOff, y + yOff, z - xSize + 1 - xOff, x + zSize - 1 + zOff, y + ySize - 1 + yOff, z - xOff);
            }
        }
        return new MutableBoundingBox(x + xOff, y + yOff, z + zOff, x + xSize - 1 + xOff, y + ySize - 1 + yOff, z + zSize - 1 + zOff);
    }

    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
    }

    protected void addNewComponent(StructurePiece entrance, List<StructurePiece> list, Random random, Rotation facing, int x, int y, int z) {
        int index = this.field_74886_g + 1;
        Direction nFacing = this.getStructureRelativeRotation(facing);
        int nx = this.func_74865_a(x, z);
        int ny = this.func_74862_a(y);
        int nz = this.func_74873_b(x, z);
        if (index > 50 || this.isOutOfRange(entrance, nx, nz, 112)) {
            return;
        }
        StructureTFStrongholdComponent breakIn = (StructureTFStrongholdComponent)this.findBreakInComponent(list, nx, ny, nz);
        if (breakIn != null && breakIn.attemptToBreakIn(nx, ny, nz)) {
            this.addDoorwayTo(x, y, z, facing);
            return;
        }
        StrongholdPieces pieceList = ((StrongholdEntranceComponent)entrance).lowerPieces;
        StructureTFStrongholdComponent nextComponent = pieceList.getNextComponent(entrance, list, random, this.getFeatureType(), index, nFacing, nx, ny, nz);
        if (nextComponent != null) {
            list.add(nextComponent);
            nextComponent.func_74861_a(entrance, list, random);
            this.addDoorwayTo(x, y, z, facing);
        }
    }

    protected StructurePiece findBreakInComponent(List<StructurePiece> list, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        for (StructurePiece component : list) {
            if (component.func_74874_b() == null || !component.func_74874_b().func_175898_b((Vector3i)pos)) continue;
            return component;
        }
        return null;
    }

    protected void addNewUpperComponent(StructurePiece parent, List<StructurePiece> list, Random random, Rotation facing, int x, int y, int z) {
        StructureTFStrongholdComponent attempted;
        int index = this.field_74886_g + 1;
        Direction nFacing = this.getStructureRelativeRotation(facing);
        int nx = this.func_74865_a(x, z);
        int ny = this.func_74862_a(y);
        int nz = this.func_74873_b(x, z);
        if (index > 100 || this.isOutOfRange(parent, nx, nz, 48)) {
            return;
        }
        switch (random.nextInt(5)) {
            default: {
                attempted = new StrongholdUpperTIntersectionComponent(this.getFeatureType(), index, nFacing, nx, ny, nz);
                break;
            }
            case 1: {
                attempted = new StrongholdUpperLeftTurnComponent(this.getFeatureType(), index, nFacing, nx, ny, nz);
                break;
            }
            case 2: {
                attempted = new StrongholdUpperRightTurnComponent(this.getFeatureType(), index, nFacing, nx, ny, nz);
                break;
            }
            case 3: {
                attempted = new StrongholdUpperCorridorComponent(this.getFeatureType(), index, nFacing, nx, ny, nz);
                break;
            }
            case 4: {
                attempted = new StrongholdUpperAscenderComponent(this.getFeatureType(), index, nFacing, nx, ny, nz);
            }
        }
        if (attempted != null && StructurePiece.func_74883_a(list, (MutableBoundingBox)attempted.func_74874_b()) == null) {
            list.add(attempted);
            attempted.func_74861_a(parent, list, random);
        }
    }

    private boolean isOutOfRange(StructurePiece parent, int nx, int nz, int range) {
        return Math.abs(nx - parent.func_74874_b().field_78897_a) > range || Math.abs(nz - parent.func_74874_b().field_78896_c) > range;
    }

    protected void placeDoorwayAt(ISeedReader world, int x, int y, int z, MutableBoundingBox sbb) {
        if (x == 0 || x == this.getXSize()) {
            this.func_175804_a(world, sbb, x, y, z - 2, x, y + 3, z + 2, this.deco.fenceState, Blocks.field_150350_a.func_176223_P(), false);
            this.func_74878_a(world, sbb, x, y, z - 1, x, y + 3, z + 1);
        } else {
            this.func_175804_a(world, sbb, x - 2, y, z, x + 2, y + 3, z, this.deco.fenceState, Blocks.field_150350_a.func_176223_P(), false);
            this.func_74878_a(world, sbb, x - 1, y, z, x + 1, y + 3, z);
        }
    }

    protected int getXSize() {
        switch (this.func_186165_e()) {
            default: {
                return this.field_74887_e.func_78883_b() - 1;
            }
            case WEST: 
            case EAST: 
        }
        return this.field_74887_e.func_78880_d() - 1;
    }

    protected void placeSmallDoorwayAt(ISeedReader world, int facing, int x, int y, int z, MutableBoundingBox sbb) {
        if (facing == 0 || facing == 2) {
            this.func_175804_a(world, sbb, x - 1, y, z, x + 1, y + 1, z, Blocks.field_150463_bK.func_176223_P(), Blocks.field_150350_a.func_176223_P(), true);
        } else {
            this.func_175804_a(world, sbb, x, y, z - 1, x, y + 1, z + 1, Blocks.field_150463_bK.func_176223_P(), Blocks.field_150350_a.func_176223_P(), true);
        }
        this.func_74878_a(world, sbb, x, y, z, x, y + 1, z);
    }

    public void placeCornerStatue(ISeedReader world, int x, int y, int z, int facing, MutableBoundingBox sbb) {
        int ox = 1;
        int oz = 1;
        Direction smx = Direction.EAST;
        Direction smz = Direction.SOUTH;
        switch (facing) {
            case 0: {
                break;
            }
            case 1: {
                oz = -1;
                smz = Direction.SOUTH;
                break;
            }
            case 2: {
                ox = -1;
                smx = Direction.WEST;
                break;
            }
            case 3: {
                ox = -1;
                oz = -1;
                smx = Direction.WEST;
                smz = Direction.NORTH;
            }
        }
        for (int sy = 0; sy < 5; ++sy) {
            this.func_175811_a(world, this.deco.pillarState, x, y + sy, z, sbb);
        }
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), x, y + 4, z + oz, sbb);
        this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), x + ox, y + 4, z, sbb);
        this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smz, false), x, y + 3, z + oz, sbb);
        this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, false), x + ox, y + 3, z, sbb);
        this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smz, true), x, y + 2, z + oz, sbb);
        this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, true), x + ox, y + 2, z, sbb);
        this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, true), x + ox, y + 2, z + oz, sbb);
        this.func_175811_a(world, Blocks.field_150463_bK.func_176223_P(), x + ox, y, z + oz, sbb);
        this.func_175811_a(world, Blocks.field_150463_bK.func_176223_P(), x + ox, y + 1, z + oz, sbb);
        this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smz, false), x, y, z + oz, sbb);
        this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, smx, false), x + ox, y, z, sbb);
    }

    public void placeWallStatue(ISeedReader world, int x, int y, int z, Rotation facing, MutableBoundingBox sbb) {
        int ox = 1;
        int oz = 1;
        for (int sy = 0; sy < 5; ++sy) {
            this.func_175811_a(world, this.deco.pillarState, x, y + sy, z, sbb);
        }
        if (facing == Rotation.NONE || facing == Rotation.CLOCKWISE_180) {
            if (facing == Rotation.CLOCKWISE_180) {
                ox = -ox;
                oz = -oz;
            }
            this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), x - ox, y + 4, z, sbb);
            this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), x + ox, y + 4, z, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.NONE).func_185831_a(Direction.WEST), false), x - ox, y + 3, z, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_180).func_185831_a(Direction.WEST), false), x + ox, y + 3, z, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_90).func_185831_a(Direction.WEST), false), x - ox, y + 3, z - oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_90).func_185831_a(Direction.WEST), false), x + ox, y + 3, z - oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.NONE).func_185831_a(Direction.WEST), true), x - ox, y + 2, z, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_180).func_185831_a(Direction.WEST), true), x + ox, y + 2, z, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_90).func_185831_a(Direction.WEST), true), x, y + 2, z - oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_90).func_185831_a(Direction.WEST), true), x - ox, y + 2, z - oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_90).func_185831_a(Direction.WEST), true), x + ox, y + 2, z - oz, sbb);
            this.func_175811_a(world, Blocks.field_150463_bK.func_176223_P(), x, y, z - oz, sbb);
            this.func_175811_a(world, Blocks.field_150463_bK.func_176223_P(), x, y + 1, z - oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.NONE).func_185831_a(Direction.WEST), false), x - ox, y, z, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_180).func_185831_a(Direction.WEST), false), x + ox, y, z, sbb);
        } else {
            if (facing == Rotation.COUNTERCLOCKWISE_90) {
                oz = -oz;
                ox = -ox;
            }
            this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), x, y + 4, z - oz, sbb);
            this.func_175811_a(world, Blocks.field_180407_aO.func_176223_P(), x, y + 4, z + oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.NONE).func_185831_a(Direction.WEST), false), x, y + 3, z - oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_180).func_185831_a(Direction.WEST), false), x, y + 3, z + oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_90).func_185831_a(Direction.WEST), false), x + ox, y + 3, z - oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_90).func_185831_a(Direction.WEST), false), x + ox, y + 3, z + oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.NONE).func_185831_a(Direction.WEST), true), x, y + 2, z - oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_180).func_185831_a(Direction.WEST), true), x, y + 2, z + oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_90).func_185831_a(Direction.WEST), true), x + oz, y + 2, z, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_90).func_185831_a(Direction.WEST), true), x + ox, y + 2, z - oz, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_90).func_185831_a(Direction.WEST), true), x + ox, y + 2, z + oz, sbb);
            this.func_175811_a(world, Blocks.field_150463_bK.func_176223_P(), x + ox, y, z, sbb);
            this.func_175811_a(world, Blocks.field_150463_bK.func_176223_P(), x + ox, y + 1, z, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.NONE).func_185831_a(Direction.WEST), false), x, y, z - ox, sbb);
            this.func_175811_a(world, StructureTFStrongholdComponent.getStairState(this.deco.stairState, facing.func_185830_a(Rotation.CLOCKWISE_180).func_185831_a(Direction.WEST), false), x, y, z + ox, sbb);
        }
    }

    public boolean attemptToBreakIn(int wx, int wy, int wz) {
        if (!this.isValidBreakInPoint(wx, wy, wz)) {
            return false;
        }
        int dx = this.getRelativeX(wx, wz);
        int dy = this.getRelativeY(wy);
        int dz = this.getRelativeZ(wx, wz);
        this.addDoor(dx, dy, dz);
        return true;
    }

    public void addDoorwayTo(int dx, int dy, int dz, Rotation facing) {
        switch (facing) {
            case NONE: {
                this.addDoor(dx, dy, dz - 1);
                break;
            }
            case CLOCKWISE_90: {
                this.addDoor(dx + 1, dy, dz);
                break;
            }
            case CLOCKWISE_180: {
                this.addDoor(dx, dy, dz + 1);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                this.addDoor(dx - 1, dy, dz);
            }
        }
    }

    public void addDoor(int dx, int dy, int dz) {
        this.doors.add(new BlockPos(dx, dy, dz));
    }

    protected boolean isValidBreakInPoint(int wx, int wy, int wz) {
        if (wy < this.field_74887_e.field_78895_b || wy > this.field_74887_e.field_78894_e) {
            return false;
        }
        if (wx == this.field_74887_e.field_78897_a || wx == this.field_74887_e.field_78893_d) {
            return wz > this.field_74887_e.field_78896_c && wz < this.field_74887_e.field_78892_f;
        }
        if (wz == this.field_74887_e.field_78896_c || wz == this.field_74887_e.field_78892_f) {
            return wx > this.field_74887_e.field_78897_a && wx < this.field_74887_e.field_78893_d;
        }
        return false;
    }

    protected int getRelativeX(int x, int z) {
        switch (this.func_186165_e()) {
            case SOUTH: {
                return x - this.field_74887_e.field_78897_a;
            }
            case NORTH: {
                return this.field_74887_e.field_78893_d - x;
            }
            case WEST: {
                return z - this.field_74887_e.field_78896_c;
            }
            case EAST: {
                return this.field_74887_e.field_78892_f - z;
            }
        }
        return x;
    }

    protected int getRelativeY(int y) {
        return y - this.field_74887_e.field_78895_b;
    }

    protected int getRelativeZ(int x, int z) {
        switch (this.func_186165_e()) {
            case SOUTH: {
                return z - this.field_74887_e.field_78896_c;
            }
            case NORTH: {
                return this.field_74887_e.field_78892_f - z;
            }
            case WEST: {
                return this.field_74887_e.field_78893_d - x;
            }
            case EAST: {
                return x - this.field_74887_e.field_78897_a;
            }
        }
        return z;
    }

    public void placeDoors(ISeedReader world, MutableBoundingBox sbb) {
        if (this.doors != null) {
            for (BlockPos doorCoords : this.doors) {
                this.placeDoorwayAt(world, doorCoords.func_177958_n(), doorCoords.func_177956_o(), doorCoords.func_177952_p(), sbb);
            }
        }
    }

    protected void placeStrongholdWalls(ISeedReader world, MutableBoundingBox sbb, int sx, int sy, int sz, int dx, int dy, int dz, Random rand, StructurePiece.BlockSelector randomBlocks) {
        for (int y = sy; y <= dy; ++y) {
            for (int x = sx; x <= dx; ++x) {
                for (int z = sz; z <= dz; ++z) {
                    boolean wall = y == sy || y == dy || x == sx || x == dx || z == sz || z == dz;
                    Block blockID = this.func_175807_a((IBlockReader)world, x, y, z, sbb).func_177230_c();
                    if (blockID == Blocks.field_150350_a && !((Boolean)TFConfig.COMMON_CONFIG.DIMENSION.skylightForest.get()).booleanValue()) {
                        if (!wall) continue;
                        this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), x, y, z, sbb);
                        continue;
                    }
                    if (y == sy || y == dy) {
                        StructurePiece.BlockSelector strongBlocks = TFStructureComponentOld.getStrongholdStones();
                        strongBlocks.func_75062_a(rand, x, y, z, wall);
                        this.func_175811_a(world, strongBlocks.func_180780_a(), x, y, z, sbb);
                        continue;
                    }
                    if (wall && blockID == Blocks.field_150346_d) continue;
                    randomBlocks.func_75062_a(rand, x, y, z, wall);
                    this.func_175811_a(world, randomBlocks.func_180780_a(), x, y, z, sbb);
                }
            }
        }
    }

    protected void placeUpperStrongholdWalls(ISeedReader world, MutableBoundingBox sbb, int sx, int sy, int sz, int dx, int dy, int dz, Random rand, StructurePiece.BlockSelector randomBlocks) {
        for (int y = sy; y <= dy; ++y) {
            for (int x = sx; x <= dx; ++x) {
                for (int z = sz; z <= dz; ++z) {
                    boolean wall = y == sy || y == dy || x == sx || x == dx || z == sz || z == dz;
                    BlockState state = this.func_175807_a((IBlockReader)world, x, y, z, sbb);
                    Block blockID = state.func_177230_c();
                    if ((blockID == Blocks.field_150350_a || state.func_185904_a() != Material.field_151576_e && state.func_185904_a() != Material.field_151577_b && state.func_185904_a() != Material.field_151578_c) && (blockID != Blocks.field_150350_a || rand.nextInt(3) != 0 || this.func_175807_a((IBlockReader)world, x, y - 1, z, sbb).func_177230_c() != Blocks.field_196696_di)) continue;
                    if (y == sy || y == dy) {
                        StructurePiece.BlockSelector strongBlocks = TFStructureComponentOld.getStrongholdStones();
                        strongBlocks.func_75062_a(rand, x, y, z, wall);
                        this.func_175811_a(world, strongBlocks.func_180780_a(), x, y, z, sbb);
                        continue;
                    }
                    randomBlocks.func_75062_a(rand, x, y, z, wall);
                    this.func_175811_a(world, randomBlocks.func_180780_a(), x, y, z, sbb);
                }
            }
        }
    }

    public static interface Factory<T extends StructureTFStrongholdComponent> {
        public T newInstance(TFFeature var1, int var2, Direction var3, int var4, int var5, int var6);
    }
}

