/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.finalcastle.FinalCastleDungeonEntranceComponent;
import twilightforest.structures.finalcastle.FinalCastleDungeonExitComponent;
import twilightforest.structures.finalcastle.FinalCastlePieces;
import twilightforest.structures.lichtower.TowerWingComponent;
import twilightforest.util.RotationUtil;

public class FinalCastleDungeonRoom31Component
extends TowerWingComponent {
    public int level;
    protected static final Predicate<Biome> plateauBiomes = biome -> true;

    public FinalCastleDungeonRoom31Component(TemplateManager manager, CompoundNBT nbt) {
        this(FinalCastlePieces.TFFCDunR31, nbt);
    }

    public FinalCastleDungeonRoom31Component(IStructurePieceType piece, CompoundNBT nbt) {
        super(piece, nbt);
    }

    public FinalCastleDungeonRoom31Component(IStructurePieceType piece, TFFeature feature, Random rand, int i, int x, int y, int z, Direction direction, int level) {
        super(piece, feature, i);
        this.func_186164_a(direction);
        this.spawnListIndex = 2;
        this.size = 31;
        this.height = 7;
        this.level = level;
        this.field_74887_e = feature.getComponentToAddBoundingBox(x, y, z, -15, 0, -15, this.size - 1, this.height - 1, this.size - 1, Direction.SOUTH);
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        int i;
        Rotation direction;
        int maxSpread;
        if (parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        int mySpread = this.func_74877_c() - parent.func_74877_c();
        int n = maxSpread = this.level == 1 ? 2 : 3;
        if (mySpread == maxSpread && !this.isExitBuildForLevel(parent)) {
            direction = RotationUtil.getRandomRotation(rand);
            for (i = 0; i < 8 && !this.isExitBuildForLevel(parent); ++i) {
                if (!this.addDungeonExit(parent, list, rand, direction = direction.func_185830_a(RotationUtil.ROTATIONS[i & 3]))) continue;
                this.setExitBuiltForLevel(parent, true);
            }
        }
        if (mySpread < maxSpread) {
            direction = RotationUtil.getRandomRotation(rand);
            for (i = 0; i < 12; ++i) {
                direction = direction.func_185830_a(RotationUtil.ROTATIONS[i & 3]);
                this.addDungeonRoom(parent, list, rand, direction, this.level);
            }
        }
    }

    private boolean isExitBuildForLevel(StructurePiece parent) {
        if (parent instanceof FinalCastleDungeonEntranceComponent) {
            return ((FinalCastleDungeonEntranceComponent)parent).hasExit;
        }
        return false;
    }

    private void setExitBuiltForLevel(StructurePiece parent, boolean exit) {
        if (parent instanceof FinalCastleDungeonEntranceComponent) {
            ((FinalCastleDungeonEntranceComponent)parent).hasExit = exit;
        }
    }

    protected boolean addDungeonRoom(StructurePiece parent, List<StructurePiece> list, Random rand, Rotation rotation, int level) {
        rotation = rotation.func_185830_a(this.field_186169_c);
        BlockPos rc = this.getNewRoomCoords(rand, rotation);
        FinalCastleDungeonRoom31Component dRoom = new FinalCastleDungeonRoom31Component(FinalCastlePieces.TFFCDunR31, this.getFeatureType(), rand, this.field_74886_g + 1, rc.func_177958_n(), rc.func_177956_o(), rc.func_177952_p(), rotation.func_185831_a(Direction.SOUTH), level);
        MutableBoundingBox largerBB = new MutableBoundingBox(dRoom.func_74874_b());
        int expand = 0;
        largerBB.field_78897_a -= expand;
        largerBB.field_78896_c -= expand;
        largerBB.field_78893_d += expand;
        largerBB.field_78892_f += expand;
        StructurePiece intersect = TFStructureComponentOld.findIntersectingExcluding(list, largerBB, this);
        if (intersect == null) {
            list.add(dRoom);
            dRoom.func_74861_a(parent, list, rand);
            return true;
        }
        return false;
    }

    protected boolean addDungeonExit(StructurePiece parent, List<StructurePiece> list, Random rand, Rotation rotation) {
        rotation = rotation.func_185830_a(this.field_186169_c);
        BlockPos rc = this.getNewRoomCoords(rand, rotation);
        FinalCastleDungeonExitComponent dRoom = new FinalCastleDungeonExitComponent(this.getFeatureType(), rand, this.field_74886_g + 1, rc.func_177958_n(), rc.func_177956_o(), rc.func_177952_p(), rotation.func_185831_a(Direction.SOUTH), this.level);
        StructurePiece intersect = TFStructureComponentOld.findIntersectingExcluding(list, dRoom.func_74874_b(), this);
        if (intersect == null) {
            list.add(dRoom);
            dRoom.func_74861_a(this, list, rand);
            return true;
        }
        return false;
    }

    private BlockPos getNewRoomCoords(Random rand, Rotation rotation) {
        int offset = rand.nextInt(15) - 9;
        if (rand.nextBoolean()) {
            offset += this.size;
        }
        switch (rotation) {
            default: {
                return new BlockPos(this.field_74887_e.field_78893_d + 9, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + offset);
            }
            case CLOCKWISE_90: {
                return new BlockPos(this.field_74887_e.field_78897_a + offset, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 9);
            }
            case CLOCKWISE_180: {
                return new BlockPos(this.field_74887_e.field_78897_a - 9, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + offset);
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new BlockPos(this.field_74887_e.field_78897_a + offset, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 9);
    }

    @Override
    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        if (this.isBoundingBoxOutsideBiomes(world, plateauBiomes)) {
            return false;
        }
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.fillWithAir(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, state -> state.func_185904_a() == Material.field_151576_e);
        BlockState floor = ((Block)TFBlocks.castle_brick.get()).func_176223_P();
        BlockState border = ((Block)TFBlocks.castle_brick_frame.get()).func_176223_P();
        Predicate<BlockState> replacing = state -> {
            Material material = state.func_185904_a();
            return material == Material.field_151576_e || material == Material.field_151579_a;
        };
        int cs = 7;
        this.fillWithBlocks(world, sbb, 7, -1, 7, this.size - 1 - 7, -1, this.size - 1 - 7, border, floor, replacing);
        this.fillWithBlocks(world, sbb, 7, this.height, 7, this.size - 1 - 7, this.height, this.size - 1 - 7, border, floor, replacing);
        BlockState forceField = this.getForceFieldColor(decoRNG);
        BlockState castleMagic = this.getRuneColor(forceField);
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            this.fillBlocksRotated(world, sbb, 7, 0, 8, 7, this.height - 1, this.size - 2 - 7, forceField, rotation);
            for (int z = 7; z < this.size - 1 - 7; z += 4) {
                this.fillBlocksRotated(world, sbb, 7, 0, z, 7, this.height - 1, z, castleMagic, rotation);
                int y = (z - 7) % 8 == 0 ? decoRNG.nextInt(3) : decoRNG.nextInt(3) + 4;
                this.fillBlocksRotated(world, sbb, 7, y, z + 1, 7, y, z + 3, castleMagic, rotation);
            }
        }
        return true;
    }

    protected BlockState getRuneColor(BlockState forceFieldColor) {
        return forceFieldColor == ((Block)TFBlocks.force_field_blue.get()).func_176223_P() ? ((Block)TFBlocks.castle_rune_brick_blue.get()).func_176223_P() : ((Block)TFBlocks.castle_rune_brick_yellow.get()).func_176223_P();
    }

    protected BlockState getForceFieldColor(Random decoRNG) {
        int i = decoRNG.nextInt(2) + 3;
        if (i == 3) {
            return ((Block)TFBlocks.force_field_green.get()).func_176223_P();
        }
        return ((Block)TFBlocks.force_field_blue.get()).func_176223_P();
    }
}

