/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fml.ModList;
import twilightforest.loot.TFTreasure;

public class ModItemSwap
extends LootFunction {
    private final Item item;
    private final Item oldItem;
    private final boolean success;

    protected ModItemSwap(ILootCondition[] conditionsIn, Item itemIn, Item old, boolean success) {
        super(conditionsIn);
        this.item = itemIn;
        this.oldItem = old;
        this.success = success;
    }

    public LootFunctionType func_230425_b_() {
        return TFTreasure.ITEM_OR_DEFAULT;
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        ItemStack newStack = new ItemStack((IItemProvider)this.item, stack.func_190916_E());
        newStack.func_77982_d(stack.func_77978_p());
        return newStack;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Serializer
    extends LootFunction.Serializer<ModItemSwap> {
        public void serialize(JsonObject object, ModItemSwap function, JsonSerializationContext serializationContext) {
            if (function.success) {
                object.addProperty("item", function.item.getRegistryName().toString());
            } else {
                object.addProperty("default", function.item.getRegistryName().toString());
            }
            object.addProperty("default", function.oldItem.getRegistryName().toString());
        }

        public ModItemSwap deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            boolean success;
            Item item;
            try {
                item = JSONUtils.func_188180_i((JsonObject)object, (String)"item");
                success = true;
            }
            catch (JsonSyntaxException e) {
                item = JSONUtils.func_188180_i((JsonObject)object, (String)"default");
                success = false;
            }
            return new ModItemSwap(conditionsIn, item, JSONUtils.func_188180_i((JsonObject)object, (String)"default"), success);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private String idtocheck;
        private Item item;
        private Item oldItem;

        protected Builder doCast() {
            return this;
        }

        public Builder apply(String modid, Item item, Item old) {
            this.idtocheck = modid;
            this.item = item;
            this.oldItem = old;
            return this;
        }

        public ILootFunction func_216052_b() {
            return new ModItemSwap(this.func_216053_g(), this.item, this.oldItem, ModList.get().isLoaded(this.idtocheck));
        }
    }
}

