/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.advancements;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.ResourceLocation;
import twilightforest.TwilightForestMod;

public class ArmorInventoryChangedTrigger
implements ICriterionTrigger<Instance> {
    public static final ResourceLocation ID = TwilightForestMod.prefix("armor_changed");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.computeIfAbsent(playerAdvancements, Listeners::new);
        listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancements);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public Instance deserialize(JsonObject json, ConditionArrayParser condition) {
        EntityPredicate.AndPredicate player = EntityPredicate.AndPredicate.func_234587_a_((JsonObject)json, (String)"player", (ConditionArrayParser)condition);
        ItemPredicate from = ItemPredicate.func_192492_a((JsonElement)json.get("from"));
        ItemPredicate to = ItemPredicate.func_192492_a((JsonElement)json.get("to"));
        return new Instance(player, from, to);
    }

    public void trigger(ServerPlayerEntity player, ItemStack from, ItemStack to) {
        Listeners listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(from, to);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ItemStack from, ItemStack to) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(from, to)) continue;
                list.add(listener);
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        private final ItemPredicate from;
        private final ItemPredicate to;

        public Instance(EntityPredicate.AndPredicate player, ItemPredicate from, ItemPredicate to) {
            super(ID, player);
            this.from = from;
            this.to = to;
        }

        public boolean test(ItemStack from, ItemStack to) {
            return this.from.func_192493_a(from) && this.to.func_192493_a(to);
        }

        public ResourceLocation func_192244_a() {
            return ID;
        }
    }
}

