/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry.util;

import architectspalette.common.blocks.VerticalSlabBlock;
import architectspalette.core.registry.util.RegistryUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.fml.RegistryObject;

public class StoneBlockSet {
    public RegistryObject<Block> SLAB;
    public RegistryObject<Block> VERTICAL_SLAB;
    public RegistryObject<Block> STAIRS;
    public RegistryObject<Block> WALL;
    public RegistryObject<Block> BLOCK;
    private final String material_name;

    public StoneBlockSet(RegistryObject<Block> base_block) {
        this(base_block, true);
    }

    public StoneBlockSet(RegistryObject<Block> base_block, Boolean auto_fill) {
        this.BLOCK = base_block;
        this.material_name = this.getMaterialFromBlock(base_block.getId().func_110623_a());
        if (auto_fill.booleanValue()) {
            this.addAll();
        }
    }

    private String getMaterialFromBlock(String block) {
        return block.replace("bricks", "brick").replace("_planks", "").replace("_block", "").replace("tiles", "tile");
    }

    private AbstractBlock.Properties properties() {
        return AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)this.BLOCK.get()));
    }

    public Block get() {
        return (Block)this.BLOCK.get();
    }

    public StoneBlockSet addSlabs() {
        this.SLAB = RegistryUtils.createBlock(this.material_name + "_slab", () -> new SlabBlock(this.properties()));
        this.VERTICAL_SLAB = RegistryUtils.createBlock(this.material_name + "_vertical_slab", () -> new VerticalSlabBlock(this.properties()));
        return this;
    }

    public StoneBlockSet addStairs() {
        this.STAIRS = RegistryUtils.createBlock(this.material_name + "_stairs", () -> new StairsBlock(() -> ((Block)this.BLOCK.get()).func_176223_P(), this.properties()));
        return this;
    }

    public StoneBlockSet addWalls() {
        this.WALL = RegistryUtils.createBlock(this.material_name + "_wall", () -> new WallBlock(this.properties()), ItemGroup.field_78031_c);
        return this;
    }

    public StoneBlockSet addAll() {
        this.addSlabs();
        this.addStairs();
        this.addWalls();
        return this;
    }
}

