/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.common.blocks;

import architectspalette.core.config.APConfig;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SunstoneBlock
extends Block {
    public static final IntegerProperty LIGHT = IntegerProperty.func_177719_a((String)"light", (int)0, (int)2);
    public Function<World, Integer> lightSupplier;

    public SunstoneBlock(AbstractBlock.Properties properties, Function<World, Integer> getLightState) {
        super(properties);
        this.lightSupplier = getLightState;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIGHT});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)LIGHT, (Comparable)this.lightSupplier.apply(context.func_195991_k()));
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        Integer lightstate;
        if (!worldIn.field_72995_K && !(lightstate = this.lightSupplier.apply((World)worldIn)).equals(state.func_177229_b((Property)LIGHT))) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIGHT, (Comparable)lightstate), 6);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Random rand;
        Double chance;
        if (facingState.func_177230_c() instanceof SunstoneBlock && (chance = (Double)APConfig.SUNSTONE_SPREAD_CHANCE.get()) > 0.0 && (rand = worldIn.func_201674_k()).nextDouble() <= chance) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, (int)(2.0 + Math.floor(rand.nextDouble() * 6.0)));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public static Integer sunstoneLight(World world) {
        return SunstoneBlock.getLightFromTime(world, 0L);
    }

    public static Integer moonstoneLight(World world) {
        return SunstoneBlock.getLightFromTime(world, 12000L);
    }

    private static Integer getLightFromTime(World world, long offset) {
        MinecraftServer s = world.func_73046_m();
        if (s == null) {
            return 0;
        }
        ServerWorld overworld = s.func_71218_a(World.field_234918_g_);
        if (overworld != null) {
            long time = (overworld.func_72820_D() + offset) % 24000L;
            if (time >= 12500L && time <= 23500L) {
                return 0;
            }
            if (time >= 3500L && time <= 8500L) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static boolean isOpaque(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Integer)state.func_177229_b((Property)LIGHT) == 0;
    }

    public static boolean isLit(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Integer)state.func_177229_b((Property)LIGHT) != 0;
    }

    public static int lightValue(BlockState state) {
        return (Integer)state.func_177229_b((Property)LIGHT) * 7;
    }
}

