/*
 * Decompiled with CFR 0.152.
 */
package mod.teamdraco.frozenup.entity;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.UUID;
import javax.annotation.Nullable;
import mod.teamdraco.frozenup.entity.ai.DiggingGoal;
import mod.teamdraco.frozenup.init.FrozenUpEntities;
import mod.teamdraco.frozenup.init.FrozenUpItems;
import mod.teamdraco.frozenup.init.FrozenUpSounds;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class ChillooEntity
extends TameableEntity {
    public static final int DIG_ANIMATION_ID = 10;
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N, Items.field_185163_cU, Items.field_151081_bc, Items.field_196130_bo, Items.field_151174_bG, Items.field_151172_bF});
    private static final BiMap<Block, DyeColor> WOOL_BLOCKS = HashBiMap.create((int)16);
    private static final DataParameter<Byte> COLOR = EntityDataManager.func_187226_a(ChillooEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    public int timeUntilNextFeather;
    public int digTimer;

    public ChillooEntity(EntityType<? extends ChillooEntity> type, World worldIn) {
        super(type, worldIn);
        this.timeUntilNextFeather = this.field_70146_Z.nextInt(10000) + 2500;
        this.digTimer = 0;
        this.field_70138_W = 1.0f;
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.4));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (Goal)new DiggingGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1){

            public boolean func_75250_a() {
                return !ChillooEntity.this.func_70909_n() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.5f : 0.7f;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151014_N || stack.func_77973_b() == Items.field_185163_cU || stack.func_77973_b() == Items.field_151081_bc || stack.func_77973_b() == Items.field_196130_bo || stack.func_77973_b() == Items.field_151174_bG || stack.func_77973_b() == Items.field_151172_bF;
    }

    public void setBandColor(DyeColor color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)(color == null ? (byte)-1 : (byte)color.ordinal()));
    }

    public DyeColor getBandColor() {
        byte color = (Byte)this.field_70180_af.func_187225_a(COLOR);
        return color == -1 || color >= 16 ? null : DyeColor.func_196056_a((int)color);
    }

    public void setSweaterColor(DyeColor color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)(color == null ? (byte)-1 : (byte)(color.ordinal() + 16)));
    }

    public DyeColor getSweaterColor() {
        byte color = (Byte)this.field_70180_af.func_187225_a(COLOR);
        return color < 16 ? null : DyeColor.func_196056_a((int)(color - 16));
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.setBandColor(DyeColor.RED);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
            this.func_70606_j(20.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(12.0);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (item == FrozenUpItems.FROZEN_TRUFFLE.get() && !this.func_70909_n()) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (!ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_152114_e((LivingEntity)player)) {
            if (item instanceof DyeItem) {
                this.setBandColor(((DyeItem)item).func_195962_g());
                stack.func_190918_g(1);
            } else {
                DyeColor dyeColor = (DyeColor)WOOL_BLOCKS.get((Object)Block.func_149634_a((Item)item));
                if (dyeColor == null) {
                    if (item == Items.field_151097_aZ) {
                        boolean failed = false;
                        DyeColor bandColor = this.getBandColor();
                        if (bandColor == null) {
                            DyeColor sweaterColor = this.getSweaterColor();
                            if (sweaterColor == null) {
                                failed = true;
                            } else {
                                this.func_199703_a((IItemProvider)WOOL_BLOCKS.inverse().get((Object)sweaterColor));
                            }
                        }
                        if (!failed) {
                            this.setBandColor(DyeColor.RED);
                            this.field_70170_p.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            stack.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(hand));
                        }
                    } else {
                        this.func_233687_w_(!this.func_233684_eK_());
                        this.field_70703_bu = false;
                        this.field_70699_by.func_75499_g();
                    }
                } else {
                    this.setSweaterColor(dyeColor);
                    stack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70089_S() && !this.func_70631_g_() && --this.timeUntilNextFeather <= 0 && this.func_70909_n()) {
                this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_199703_a((IItemProvider)FrozenUpItems.CHILLOO_FEATHER.get());
                this.timeUntilNextFeather = this.field_70146_Z.nextInt(10000) + 5000;
            }
        } else if (this.digTimer > 0) {
            --this.digTimer;
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        ChillooEntity chilloo = (ChillooEntity)((EntityType)FrozenUpEntities.CHILLOO.get()).func_200721_a(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            chilloo.func_184754_b(uuid);
            chilloo.func_70903_f(true);
        }
        return chilloo;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)FrozenUpSounds.CHILLOO_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)FrozenUpSounds.CHILLOO_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)FrozenUpSounds.CHILLOO_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74771_c("Colors"));
        if (compound.func_74764_b("FeatherLayTime")) {
            this.timeUntilNextFeather = compound.func_74762_e("FeatherLayTime");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("Colors", ((Byte)this.field_70180_af.func_187225_a(COLOR)).byteValue());
        compound.func_74768_a("FeatherLayTime", this.timeUntilNextFeather);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)FrozenUpItems.CHILLOO_SPAWN_EGG.get());
    }

    public void func_70103_a(byte id) {
        if (id == 10) {
            this.digTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    static {
        WOOL_BLOCKS.put((Object)Blocks.field_196556_aL, (Object)DyeColor.WHITE);
        WOOL_BLOCKS.put((Object)Blocks.field_196557_aM, (Object)DyeColor.ORANGE);
        WOOL_BLOCKS.put((Object)Blocks.field_196558_aN, (Object)DyeColor.MAGENTA);
        WOOL_BLOCKS.put((Object)Blocks.field_196559_aO, (Object)DyeColor.LIGHT_BLUE);
        WOOL_BLOCKS.put((Object)Blocks.field_196560_aP, (Object)DyeColor.YELLOW);
        WOOL_BLOCKS.put((Object)Blocks.field_196561_aQ, (Object)DyeColor.LIME);
        WOOL_BLOCKS.put((Object)Blocks.field_196562_aR, (Object)DyeColor.PINK);
        WOOL_BLOCKS.put((Object)Blocks.field_196563_aS, (Object)DyeColor.GRAY);
        WOOL_BLOCKS.put((Object)Blocks.field_196564_aT, (Object)DyeColor.LIGHT_GRAY);
        WOOL_BLOCKS.put((Object)Blocks.field_196565_aU, (Object)DyeColor.CYAN);
        WOOL_BLOCKS.put((Object)Blocks.field_196566_aV, (Object)DyeColor.PURPLE);
        WOOL_BLOCKS.put((Object)Blocks.field_196567_aW, (Object)DyeColor.BLUE);
        WOOL_BLOCKS.put((Object)Blocks.field_196568_aX, (Object)DyeColor.BROWN);
        WOOL_BLOCKS.put((Object)Blocks.field_196569_aY, (Object)DyeColor.GREEN);
        WOOL_BLOCKS.put((Object)Blocks.field_196570_aZ, (Object)DyeColor.RED);
        WOOL_BLOCKS.put((Object)Blocks.field_196602_ba, (Object)DyeColor.BLACK);
    }
}

