/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.infamous.dungeons_libraries.capabilities.minionmaster.IMaster;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import com.infamous.dungeons_libraries.utils.AbilityHelper;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;

public class PetHelper {
    public static void makeNearbyPetsAttackTarget(LivingEntity target, LivingEntity owner) {
        if (PetHelper.isPetOf(target, owner) || PetHelper.isPetOf(owner, target)) {
            return;
        }
        IMaster masterCapability = MinionMasterHelper.getMasterCapability((Entity)owner);
        if (masterCapability == null) {
            return;
        }
        List nearbyEntities = owner.func_130014_f_().func_225316_b(LivingEntity.class, owner.func_174813_aQ().func_186662_g(12.0), nearbyEntity -> PetHelper.isPetOf(owner, nearbyEntity));
        HashSet<Entity> pets = new HashSet<Entity>();
        pets.addAll(masterCapability.getAllMinions());
        pets.addAll(nearbyEntities);
        for (Entity pet : pets) {
            if (!(pet instanceof MobEntity)) continue;
            ((MobEntity)pet).func_70624_b(target);
        }
    }

    public static boolean canPetAttackEntity(LivingEntity pet, LivingEntity target) {
        return pet.func_70089_S() && AbilityHelper.canApplyToEnemy(pet, target);
    }

    public static boolean isPetOf(LivingEntity possibleOwner, LivingEntity possiblePet) {
        return PetHelper.getOwner(possiblePet) == possibleOwner;
    }

    public static boolean isPetOrColleagueRelation(LivingEntity potentialPet1, LivingEntity potentialPet2) {
        LivingEntity owner = PetHelper.getOwner(potentialPet1);
        LivingEntity otherOwner = PetHelper.getOwner(potentialPet2);
        if (owner == null) {
            return potentialPet1 == otherOwner;
        }
        if (otherOwner == null) {
            return potentialPet2 == owner;
        }
        return owner == otherOwner;
    }

    public static LivingEntity getOwner(LivingEntity potentialPet) {
        LivingEntity owner = null;
        if (potentialPet instanceof TameableEntity) {
            owner = ((TameableEntity)potentialPet).func_70902_q();
        }
        if (potentialPet instanceof AbstractHorseEntity) {
            owner = MinionMasterHelper.getOwnerForHorse((AbstractHorseEntity)potentialPet);
        }
        if (MinionMasterHelper.getMaster(potentialPet) != null) {
            owner = MinionMasterHelper.getMaster(potentialPet);
        }
        return owner;
    }
}

