/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.infamous.dungeons_libraries.capabilities.enchantedprojectile.EnchantedProjectile;
import com.infamous.dungeons_libraries.capabilities.enchantedprojectile.EnchantedProjectileHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class ArrowHelper {
    @SubscribeEvent
    public static void onArrowJoinWorld(EntityJoinWorldEvent event) {
        AbstractArrowEntity arrowEntity;
        Entity shooterEntity;
        if (event.getEntity() instanceof AbstractArrowEntity && (shooterEntity = (arrowEntity = (AbstractArrowEntity)event.getEntity()).func_234616_v_()) instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)shooterEntity;
            ItemStack mainhandStack = shooter.func_184614_ca();
            ItemStack offhandStack = shooter.func_184592_cb();
            if (mainhandStack.func_77973_b() instanceof BowItem || mainhandStack.func_77973_b() instanceof CrossbowItem) {
                ArrowHelper.handleRangedEnchantments(arrowEntity, shooter, mainhandStack);
            } else if (offhandStack.func_77973_b() instanceof BowItem || offhandStack.func_77973_b() instanceof CrossbowItem) {
                ArrowHelper.handleRangedEnchantments(arrowEntity, shooter, offhandStack);
            }
        }
    }

    private static void handleRangedEnchantments(AbstractArrowEntity arrowEntity, LivingEntity shooter, ItemStack stack) {
        ArrowHelper.addEnchantmentTagsToArrow(stack, (ProjectileEntity)arrowEntity);
    }

    public static boolean hasEnchantment(ItemStack stack, Enchantment enchantment) {
        return enchantment != null && EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack) > 0;
    }

    public static boolean hasEnchantment(LivingEntity entity, Enchantment enchantment) {
        return enchantment != null && EnchantmentHelper.func_185284_a((Enchantment)enchantment, (LivingEntity)entity) > 0;
    }

    public static boolean shooterIsLiving(AbstractArrowEntity arrowEntity) {
        return arrowEntity.func_234616_v_() != null && arrowEntity.func_234616_v_() instanceof LivingEntity;
    }

    public static boolean arrowHitLivingEntity(RayTraceResult rayTraceResult) {
        if (rayTraceResult instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)rayTraceResult;
            return entityRayTraceResult.func_216348_a() instanceof LivingEntity;
        }
        return false;
    }

    public static boolean arrowHitMob(RayTraceResult rayTraceResult) {
        if (rayTraceResult instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)rayTraceResult;
            return entityRayTraceResult.func_216348_a() instanceof MobEntity;
        }
        return false;
    }

    public static void addEnchantmentTagsToArrow(ItemStack itemStack, ProjectileEntity projectileEntity) {
        EnchantedProjectile cap = EnchantedProjectileHelper.getEnchantedProjectileCapability((Entity)projectileEntity);
        if (cap != null) {
            cap.setEnchantments(itemStack);
        }
    }

    public static int enchantmentTagToLevel(ProjectileEntity projectileEntity, Enchantment enchantment) {
        EnchantedProjectile cap = EnchantedProjectileHelper.getEnchantedProjectileCapability((Entity)projectileEntity);
        if (cap != null) {
            return cap.getEnchantmentLevel(enchantment);
        }
        return 0;
    }
}

