/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.infamous.dungeons_libraries.config.DungeonsLibrariesConfig;
import com.infamous.dungeons_libraries.utils.PetHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AbilityHelper {
    public static boolean isFacingEntity(Entity looker, Entity target, Vector3d look, int angle) {
        double cos;
        if (angle <= 0) {
            return false;
        }
        Vector3d posVec = target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0);
        Vector3d relativePosVec = posVec.func_72444_a(looker.func_213303_ch().func_72441_c(0.0, (double)looker.func_70047_e(), 0.0)).func_72432_b();
        double dotsq = relativePosVec.func_72430_b(look) * Math.abs(relativePosVec.func_72430_b(look)) / (relativePosVec.func_189985_c() * look.func_189985_c());
        return dotsq < -((cos = (double)MathHelper.func_76134_b((float)((float)((double)angle / 360.0 * Math.PI)))) * cos);
    }

    private static boolean isNotTheTargetOrAttacker(LivingEntity attacker, LivingEntity target, LivingEntity nearbyEntity) {
        return nearbyEntity != target && nearbyEntity != attacker;
    }

    private static boolean isBothPlayerAndNoPvP(LivingEntity attacker, LivingEntity nearbyEntity) {
        return attacker instanceof PlayerEntity && nearbyEntity instanceof PlayerEntity && (Boolean)DungeonsLibrariesConfig.ENABLE_AREA_OF_EFFECT_ON_OTHER_PLAYERS.get() == false;
    }

    public static boolean canHealEntity(LivingEntity healer, LivingEntity nearbyEntity) {
        return nearbyEntity != healer && AbilityHelper.isAlly(healer, nearbyEntity) && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, healer);
    }

    public static boolean isAlly(LivingEntity origin, LivingEntity target) {
        LivingEntity originOwner = PetHelper.getOwner(origin);
        LivingEntity targetOwner = PetHelper.getOwner(target);
        if (originOwner != null || targetOwner != null) {
            return AbilityHelper.isAlly(originOwner != null ? originOwner : origin, targetOwner != null ? targetOwner : target);
        }
        return PetHelper.isPetOrColleagueRelation(origin, target) || origin.func_184191_r((Entity)target) || AbilityHelper.isBothPlayerAndNoPvP(origin, target) || origin.getClassification(false).equals((Object)EntityClassification.MONSTER) && target.getClassification(false).equals((Object)EntityClassification.MONSTER) || AbilityHelper.isEntityBlacklisted(origin, target);
    }

    private static boolean isEntityBlacklisted(LivingEntity origin, LivingEntity target) {
        if (target.func_200600_R().equals(EntityType.field_200789_c)) {
            return true;
        }
        return origin instanceof PlayerEntity && !target.getClassification(false).equals((Object)EntityClassification.MONSTER) && !((List)DungeonsLibrariesConfig.ENEMY_WHITELIST.get()).contains(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)target.func_200600_R()).toString()) || ((List)DungeonsLibrariesConfig.ENEMY_BLACKLIST.get()).contains(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)target.func_200600_R()).toString());
    }

    private static boolean isAliveAndCanBeSeen(LivingEntity nearbyEntity, LivingEntity attacker) {
        return nearbyEntity.func_70089_S() && attacker.func_70685_l((Entity)nearbyEntity);
    }

    public static boolean canApplyToSecondEnemy(LivingEntity attacker, LivingEntity target, LivingEntity nearbyEntity) {
        return AbilityHelper.isNotTheTargetOrAttacker(attacker, target, nearbyEntity) && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, attacker) && !AbilityHelper.isAlly(attacker, nearbyEntity);
    }

    public static boolean canApplyToEnemy(LivingEntity attacker, LivingEntity nearbyEntity) {
        return nearbyEntity != attacker && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, attacker) && !AbilityHelper.isAlly(attacker, nearbyEntity);
    }
}

