/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.summon;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.capabilities.minionmaster.IMaster;
import com.infamous.dungeons_libraries.capabilities.minionmaster.IMinion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import com.infamous.dungeons_libraries.summon.SummonConfigRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.util.math.BlockPos;

public class SummonHelper {
    private static boolean addSummonedMob(LivingEntity master, Entity entity) {
        IMaster masterCap = MinionMasterHelper.getMasterCapability((Entity)master);
        if (masterCap == null) {
            return false;
        }
        if (SummonHelper.canSummonMob(master, entity, masterCap)) {
            return masterCap.addSummonedMob(entity);
        }
        return false;
    }

    private static boolean canSummonMob(LivingEntity master, Entity beeEntity, IMaster masterCap) {
        ModifiableAttributeInstance summonCap = master.func_110148_a((Attribute)AttributeRegistry.SUMMON_CAP.get());
        if (summonCap == null) {
            return false;
        }
        return (double)(masterCap.getSummonedMobsCost() + SummonConfigRegistry.getConfig(beeEntity.func_200600_R().getRegistryName()).getCost()) <= summonCap.func_111126_e();
    }

    public static boolean canSummonMob(LivingEntity master, IMaster masterCap) {
        ModifiableAttributeInstance summonCap = master.func_110148_a((Attribute)AttributeRegistry.SUMMON_CAP.get());
        if (summonCap == null) {
            return false;
        }
        return (double)masterCap.getSummonedMobsCost() < summonCap.func_111126_e();
    }

    public static Entity summonEntity(LivingEntity master, BlockPos position, EntityType<?> entityType) {
        Entity entity = entityType.func_200721_a(master.field_70170_p);
        if (entity != null) {
            IMinion summonable = MinionMasterHelper.getMinionCapability(entity);
            if (summonable != null && SummonHelper.addSummonedMob(master, entity)) {
                summonable.setMaster(master);
                summonable.setSummon(true);
                SummonHelper.createSummon(master, entity, position);
                return entity;
            }
            entity.func_70106_y();
        }
        return null;
    }

    private static void createSummon(LivingEntity master, Entity entity, BlockPos position) {
        entity.func_70012_b((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.05, (double)position.func_177952_p() + 0.5, 0.0f, 0.0f);
        if (entity instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)entity;
            MinionMasterHelper.addMinionGoals(mobEntity);
        }
        master.field_70170_p.func_217376_c(entity);
    }
}

