/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network.message;

import com.infamous.dungeons_libraries.network.client.ClientHandler;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class EliteMobMessage {
    private int entityId;
    private boolean isElite;
    private ResourceLocation texture;

    public EliteMobMessage(int entityId, boolean isElite, ResourceLocation texture) {
        this.entityId = entityId;
        this.isElite = isElite;
        this.texture = texture;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeBoolean(this.isElite);
        buffer.func_192572_a(this.texture);
    }

    public static EliteMobMessage decode(PacketBuffer buffer) {
        int entityId = buffer.readInt();
        boolean isElite = buffer.readBoolean();
        ResourceLocation texture = buffer.func_192575_l();
        return new EliteMobMessage(entityId, isElite, texture);
    }

    public static void onPacketReceived(EliteMobMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        ClientHandler.handleEliteMobMessage(message, contextSupplier);
        contextSupplier.get().setPacketHandled(true);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean isElite() {
        return this.isElite;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }
}

