/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network.materials;

import com.infamous.dungeons_libraries.items.GearConfigReloadListener;
import com.infamous.dungeons_libraries.items.materials.weapon.DungeonsWeaponMaterial;
import com.infamous.dungeons_libraries.items.materials.weapon.WeaponMaterials;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.item.IItemTier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class WeaponMaterialSyncPacket {
    private static final Codec<Map<ResourceLocation, IItemTier>> MAPPER = Codec.unboundedMap((Codec)ResourceLocation.field_240908_a_, DungeonsWeaponMaterial.CODEC);
    public final Map<ResourceLocation, IItemTier> data;

    public WeaponMaterialSyncPacket(Map<ResourceLocation, IItemTier> data) {
        this.data = data.entrySet().stream().filter(entry -> entry.getValue() instanceof DungeonsWeaponMaterial).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150786_a(MAPPER.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, this.data).result().orElse(new CompoundNBT()));
    }

    public static WeaponMaterialSyncPacket decode(PacketBuffer buffer) {
        return new WeaponMaterialSyncPacket(MAPPER.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)buffer.func_150793_b()).result().orElse(new HashMap()));
    }

    public void onPacketReceived(Supplier<NetworkEvent.Context> contextGetter) {
        NetworkEvent.Context context = contextGetter.get();
        context.enqueueWork(this::handlePacketOnMainThread);
        context.setPacketHandled(true);
    }

    private void handlePacketOnMainThread() {
        WeaponMaterials.WEAPON_MATERIALS.data = this.data;
        GearConfigReloadListener.reloadAllItems();
    }
}

