/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network.client;

import com.infamous.dungeons_libraries.capabilities.artifact.ArtifactUsageHelper;
import com.infamous.dungeons_libraries.capabilities.artifact.IArtifactUsage;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMob;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMobHelper;
import com.infamous.dungeons_libraries.integration.curios.client.message.CuriosArtifactStopMessage;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.infamous.dungeons_libraries.network.message.EliteMobMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class ClientHandler {
    public static void handleCuriosArtifactStopMessage(CuriosArtifactStopMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context;
        if (message != null && (context = contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                ItemStack artifactStack;
                IArtifactUsage cap;
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player != null && (cap = ArtifactUsageHelper.getArtifactUsageCapability((Entity)player)) != null && (artifactStack = cap.getUsingArtifact()) != null && artifactStack.func_77973_b() instanceof ArtifactItem) {
                    ArtifactItem artifactItem = (ArtifactItem)artifactStack.func_77973_b();
                    artifactItem.stopUsingArtifact((LivingEntity)player);
                    cap.stopUsingArtifact();
                }
            });
        }
    }

    public static void handleEliteMobMessage(EliteMobMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(message.getEntityId());
                if (entity instanceof LivingEntity) {
                    EliteMob cap = EliteMobHelper.getEliteMobCapability(entity);
                    if (cap == null) {
                        return;
                    }
                    cap.setElite(message.isElite());
                    cap.setTexture(message.getTexture());
                    if (cap.isElite()) {
                        entity.func_213323_x_();
                    }
                }
            });
        }
    }
}

