/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network;

import com.infamous.dungeons_libraries.capabilities.enchantable.EnchantableHelper;
import com.infamous.dungeons_libraries.mobenchantments.MobEnchantment;
import com.infamous.dungeons_libraries.mobenchantments.MobEnchantmentsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MobEnchantmentMessage {
    private int entityId;
    private List<MobEnchantment> mobEnchantments;

    public MobEnchantmentMessage(int entityId, List<MobEnchantment> mobEnchantments) {
        this.entityId = entityId;
        this.mobEnchantments = mobEnchantments;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_150787_b(this.mobEnchantments.size());
        this.mobEnchantments.forEach(mobEnchantment -> buffer.func_192572_a(mobEnchantment.getRegistryName()));
    }

    public static MobEnchantmentMessage decode(PacketBuffer buffer) {
        int entityId = buffer.readInt();
        ArrayList<MobEnchantment> mobEnchantments = new ArrayList<MobEnchantment>();
        int length = buffer.func_150792_a();
        for (int x = 0; x < length; ++x) {
            mobEnchantments.add((MobEnchantment)MobEnchantmentsRegistry.MOB_ENCHANTMENTS.getValue(buffer.func_192575_l()));
        }
        return new MobEnchantmentMessage(entityId, mobEnchantments);
    }

    public static boolean onPacketReceived(MobEnchantmentMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(message.entityId);
                if (entity instanceof LivingEntity) {
                    EnchantableHelper.getEnchantableCapabilityLazy(entity).ifPresent(iEnchantable -> {
                        iEnchantable.clearAllEnchantments();
                        message.mobEnchantments.forEach(iEnchantable::addEnchantment);
                        if (!message.mobEnchantments.isEmpty()) {
                            entity.func_213323_x_();
                        }
                    });
                }
            });
        }
        return true;
    }
}

