/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class BreakItemMessage {
    private final ItemStack stack;
    private final int entityID;

    public BreakItemMessage(int entityID, ItemStack stack) {
        this.stack = stack;
        this.entityID = entityID;
    }

    public static void encode(BreakItemMessage packet, PacketBuffer buf) {
        buf.writeInt(packet.entityID);
        buf.func_150788_a(packet.stack);
    }

    public static BreakItemMessage decode(PacketBuffer buf) {
        return new BreakItemMessage(buf.readInt(), buf.func_150791_c());
    }

    public static class BreakItemHandler {
        public static void handle(final BreakItemMessage packet, Supplier<NetworkEvent.Context> ctx) {
            if (packet != null) {
                ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){
                    private static final long serialVersionUID = 1L;

                    public void run() {
                        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                        Entity target = null;
                        if (world != null) {
                            target = world.func_73045_a(packet.entityID);
                        }
                        if (target instanceof LivingEntity) {
                            ((LivingEntity)target).func_70669_a(packet.stack);
                        }
                    }
                }));
            }
        }
    }
}

