/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.mobenchantments;

import com.google.common.collect.Lists;
import com.infamous.dungeons_libraries.capabilities.enchantable.EnchantableHelper;
import com.infamous.dungeons_libraries.mobenchantments.MobEnchantment;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ShulkerEntity;

public class MobEnchantmentHelper {
    public static void executeIfPresent(LivingEntity entity, MobEnchantment mobEnchantment, Runnable runnable) {
        if (entity != null) {
            EnchantableHelper.getEnchantableCapabilityLazy((Entity)entity).ifPresent(cap -> {
                if (cap.hasEnchantment(mobEnchantment)) {
                    runnable.run();
                }
            });
        }
    }

    public static MobEnchantment getRandomMobEnchantment(Random random, List<MobEnchantment> mobEnchantments) {
        int index;
        double totalWeight = 0.0;
        for (MobEnchantment mobEnchantment : mobEnchantments) {
            totalWeight += (double)mobEnchantment.getRarity().getWeight();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < mobEnchantments.size() - 1 && !((randomWeightPicked -= (double)mobEnchantments.get(index).getRarity().getWeight()) <= 0.0); ++index) {
        }
        return mobEnchantments.get(index);
    }

    public static ArrayList<MobEnchantment.Type> getPossibleTypes(Entity entity) {
        if (entity instanceof IRangedAttackMob || entity instanceof ShulkerEntity) {
            return Lists.newArrayList((Object[])new MobEnchantment.Type[]{MobEnchantment.Type.ANY, MobEnchantment.Type.RANGED});
        }
        return Lists.newArrayList((Object[])new MobEnchantment.Type[]{MobEnchantment.Type.ANY});
    }

    public static boolean hasType(MobEnchantment mobEnchantment, ArrayList<MobEnchantment.Type> possibleTypes) {
        return possibleTypes.contains((Object)mobEnchantment.getType());
    }
}

