/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.mobenchantments;

import com.infamous.dungeons_libraries.mobenchantments.MobEnchantmentsRegistry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MobEnchantment
extends ForgeRegistryEntry<MobEnchantment> {
    private Rarity rarity;
    private Type type;
    private String descriptionId;

    public MobEnchantment(Rarity rarity) {
        this.rarity = rarity;
        this.type = Type.ANY;
    }

    public MobEnchantment(Rarity rarity, Type type) {
        this.rarity = rarity;
        this.type = type;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public Type getType() {
        return this.type;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.func_200697_a((String)"mobEnchantment", (ResourceLocation)MobEnchantmentsRegistry.MOB_ENCHANTMENTS.getKey((IForgeRegistryEntry)this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(this.getDescriptionId());
    }

    public static enum Type {
        ANY,
        RANGED;

    }

    public static enum Rarity {
        COMMON(10),
        UNCOMMON(5),
        RARE(2),
        VERY_RARE(1);

        private final int weight;

        private Rarity(int rarityWeight) {
            this.weight = rarityWeight;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

