/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.materials.weapon;

import com.infamous.dungeons_libraries.DungeonsLibraries;
import com.infamous.dungeons_libraries.data.util.DefaultsCodecJsonDataManager;
import com.infamous.dungeons_libraries.items.materials.weapon.DungeonsWeaponMaterial;
import com.infamous.dungeons_libraries.network.materials.WeaponMaterialSyncPacket;
import java.util.Collection;
import java.util.Map;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemTier;
import net.minecraft.util.ResourceLocation;

public class WeaponMaterials {
    public static final DefaultsCodecJsonDataManager<IItemTier> WEAPON_MATERIALS = new DefaultsCodecJsonDataManager<IItemTier>("material/weapon", DungeonsWeaponMaterial.CODEC, DungeonsLibraries.LOGGER);

    public static void setupVanillaMaterials() {
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:wood"), (IItemTier)ItemTier.WOOD);
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:stone"), (IItemTier)ItemTier.STONE);
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:iron"), (IItemTier)ItemTier.IRON);
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:diamond"), (IItemTier)ItemTier.DIAMOND);
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:gold"), (IItemTier)ItemTier.GOLD);
        WEAPON_MATERIALS.addDefault(new ResourceLocation("minecraft:netherite"), (IItemTier)ItemTier.NETHERITE);
    }

    public static IItemTier getWeaponMaterial(ResourceLocation resourceLocation) {
        return (IItemTier)WeaponMaterials.WEAPON_MATERIALS.data.getOrDefault(resourceLocation, ItemTier.IRON);
    }

    public static boolean WeaponMaterialExists(ResourceLocation boostResourceLocation) {
        return WeaponMaterials.WEAPON_MATERIALS.data.containsKey(boostResourceLocation);
    }

    public static Collection<ResourceLocation> weaponMaterialsKeys() {
        return WeaponMaterials.WEAPON_MATERIALS.data.keySet();
    }

    public static WeaponMaterialSyncPacket toPacket(Map<ResourceLocation, IItemTier> map) {
        return new WeaponMaterialSyncPacket(map);
    }
}

