/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.materials.weapon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class DungeonsWeaponMaterial
implements IItemTier {
    public static final Codec<IItemTier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).getName()), (App)SoundEvent.field_232678_a_.fieldOf("equip_sound").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).getEquipSound()), (App)Codec.INT.fieldOf("durability").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).func_200926_a()), (App)Codec.INT.fieldOf("enchantability").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).func_200927_e()), (App)ResourceLocation.field_240908_a_.fieldOf("repair_item").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).getRepairItemResourceLocation()), (App)Codec.FLOAT.fieldOf("attack_speed").forGetter(iItemTier -> Float.valueOf(((DungeonsWeaponMaterial)iItemTier).func_200928_b())), (App)Codec.FLOAT.fieldOf("attack_damage").forGetter(iItemTier -> Float.valueOf(((DungeonsWeaponMaterial)iItemTier).func_200929_c())), (App)Codec.INT.fieldOf("level").forGetter(iItemTier -> ((DungeonsWeaponMaterial)iItemTier).func_200925_d())).apply((Applicative)instance, DungeonsWeaponMaterial::new));
    private final String name;
    private final SoundEvent equipSound;
    private final int durability;
    private final int enchantability;
    private final ResourceLocation repairItemResourceLocation;
    private final Ingredient repairItem;
    private final float attackSpeed;
    private final float attackDamageBonus;
    private final int level;

    public DungeonsWeaponMaterial(String name, SoundEvent equipSound, int durability, int enchantability, ResourceLocation repairItemResourceLocation, float attackSpeed, float attackDamageBonus, int level) {
        this.name = name;
        this.equipSound = equipSound;
        this.durability = durability;
        this.enchantability = enchantability;
        this.repairItemResourceLocation = repairItemResourceLocation;
        if (ForgeRegistries.ITEMS.containsKey(repairItemResourceLocation)) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(repairItemResourceLocation);
            this.repairItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
        } else {
            this.repairItem = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j});
        }
        this.attackSpeed = attackSpeed;
        this.attackDamageBonus = attackDamageBonus;
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public SoundEvent getEquipSound() {
        return this.equipSound;
    }

    public int func_200926_a() {
        return this.durability;
    }

    public int func_200927_e() {
        return this.enchantability;
    }

    public ResourceLocation getRepairItemResourceLocation() {
        return this.repairItemResourceLocation;
    }

    public Ingredient func_200924_f() {
        return this.repairItem;
    }

    public float func_200928_b() {
        return this.attackSpeed;
    }

    public float func_200929_c() {
        return this.attackDamageBonus;
    }

    public int func_200925_d() {
        return this.level;
    }
}

