/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.materials.armor;

import com.infamous.dungeons_libraries.items.materials.armor.ArmorMaterialBaseType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class DungeonsArmorMaterial
implements IArmorMaterial {
    public static final Codec<IArmorMaterial> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).func_200897_d()), (App)Codec.INT.fieldOf("durability").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).durability), (App)Codec.INT.listOf().fieldOf("damage_reduction_amounts").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).damageReductionAmounts), (App)Codec.INT.fieldOf("enchantability").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).func_200900_a()), (App)ResourceLocation.field_240908_a_.fieldOf("repair_item").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).repairItemResourceLocation), (App)SoundEvent.field_232678_a_.fieldOf("equip_sound").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).func_200899_b()), (App)Codec.FLOAT.fieldOf("toughness").forGetter(iArmorMaterial -> Float.valueOf(((DungeonsArmorMaterial)iArmorMaterial).func_200901_e())), (App)Codec.FLOAT.fieldOf("knockback_resistance").forGetter(iArmorMaterial -> Float.valueOf(((DungeonsArmorMaterial)iArmorMaterial).func_230304_f_())), (App)ArmorMaterialBaseType.CODEC.fieldOf("base_type").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).baseType)).apply((Applicative)instance, DungeonsArmorMaterial::new));
    private static final int[] BASE_DURABILITY_ARRAY = new int[]{13, 15, 16, 11};
    private final String name;
    private final SoundEvent equipSound;
    private final int durability;
    private final int enchantability;
    private final ResourceLocation repairItemResourceLocation;
    private final LazyValue<Ingredient> repairItem;
    private final List<Integer> damageReductionAmounts;
    private final float toughness;
    private final float knockbackResistance;
    private final ArmorMaterialBaseType baseType;

    private DungeonsArmorMaterial(String name, int durability, List<Integer> damageReductionAmounts, int enchantability, ResourceLocation repairItemResourceLocation, SoundEvent equipSound, float toughness, float knockbackResistance, ArmorMaterialBaseType baseType) {
        this.name = name;
        this.equipSound = equipSound;
        this.durability = durability;
        this.enchantability = enchantability;
        this.repairItemResourceLocation = repairItemResourceLocation;
        if (ForgeRegistries.ITEMS.containsKey(repairItemResourceLocation)) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(repairItemResourceLocation);
            this.repairItem = new LazyValue(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
        } else {
            this.repairItem = new LazyValue(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}));
        }
        this.damageReductionAmounts = damageReductionAmounts;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.baseType = baseType;
    }

    public int func_200902_b(EquipmentSlotType slot) {
        return this.damageReductionAmounts.get(slot.func_188454_b());
    }

    public int func_200896_a(EquipmentSlotType slot) {
        return BASE_DURABILITY_ARRAY[slot.func_188454_b()] * this.durability;
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public String func_200897_d() {
        return this.name;
    }

    public Ingredient func_200898_c() {
        return (Ingredient)this.repairItem.func_179281_c();
    }

    public SoundEvent func_200899_b() {
        return this.equipSound;
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public float func_230304_f_() {
        return this.knockbackResistance;
    }

    public ArmorMaterialBaseType getBaseType() {
        return this.baseType;
    }
}

