/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.materials.armor;

import com.infamous.dungeons_libraries.DungeonsLibraries;
import com.infamous.dungeons_libraries.data.util.DefaultsCodecJsonDataManager;
import com.infamous.dungeons_libraries.items.materials.armor.ArmorMaterialBaseType;
import com.infamous.dungeons_libraries.items.materials.armor.DungeonsArmorMaterial;
import com.infamous.dungeons_libraries.network.materials.ArmorMaterialSyncPacket;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.util.ResourceLocation;

public class ArmorMaterials {
    public static final DefaultsCodecJsonDataManager<IArmorMaterial> ARMOR_MATERIALS = new DefaultsCodecJsonDataManager<IArmorMaterial>("material/armor", DungeonsArmorMaterial.CODEC, DungeonsLibraries.LOGGER);
    public static final Map<IArmorMaterial, ArmorMaterialBaseType> baseArmorMaterials = new HashMap<IArmorMaterial, ArmorMaterialBaseType>();

    public static void setupVanillaMaterials() {
        ArmorMaterials.addDefaultArmorMaterial(ArmorMaterial.LEATHER, ArmorMaterialBaseType.LEATHER, new ResourceLocation("minecraft:leather"));
        ArmorMaterials.addDefaultArmorMaterial(ArmorMaterial.CHAIN, ArmorMaterialBaseType.METAL, new ResourceLocation("minecraft:chainmail"));
        ArmorMaterials.addDefaultArmorMaterial(ArmorMaterial.IRON, ArmorMaterialBaseType.METAL, new ResourceLocation("minecraft:iron"));
        ArmorMaterials.addDefaultArmorMaterial(ArmorMaterial.GOLD, ArmorMaterialBaseType.METAL, new ResourceLocation("minecraft:gold"));
        ArmorMaterials.addDefaultArmorMaterial(ArmorMaterial.DIAMOND, ArmorMaterialBaseType.GEM, new ResourceLocation("minecraft:diamond"));
        ArmorMaterials.addDefaultArmorMaterial(ArmorMaterial.TURTLE, ArmorMaterialBaseType.LEATHER, new ResourceLocation("minecraft:turtle"));
        ArmorMaterials.addDefaultArmorMaterial(ArmorMaterial.NETHERITE, ArmorMaterialBaseType.METAL, new ResourceLocation("minecraft:netherite"));
    }

    public static void addDefaultArmorMaterial(ArmorMaterial material, ArmorMaterialBaseType baseType, ResourceLocation resourceLocation) {
        ARMOR_MATERIALS.addDefault(resourceLocation, (IArmorMaterial)material);
        baseArmorMaterials.put((IArmorMaterial)material, baseType);
    }

    public static IArmorMaterial getArmorMaterial(ResourceLocation resourceLocation) {
        return (IArmorMaterial)ArmorMaterials.ARMOR_MATERIALS.data.getOrDefault(resourceLocation, ArmorMaterial.IRON);
    }

    public static boolean ArmorMaterialExists(ResourceLocation resourceLocation) {
        return ArmorMaterials.ARMOR_MATERIALS.data.containsKey(resourceLocation);
    }

    public static Collection<ResourceLocation> armorMaterialsKeys() {
        return ArmorMaterials.ARMOR_MATERIALS.data.keySet();
    }

    public static Collection<IArmorMaterial> getArmorMaterials(ArmorMaterialBaseType baseType) {
        return ArmorMaterials.ARMOR_MATERIALS.data.values().stream().filter(iArmorMaterial -> {
            if (iArmorMaterial instanceof DungeonsArmorMaterial) {
                return ((DungeonsArmorMaterial)iArmorMaterial).getBaseType() == baseType;
            }
            if (baseArmorMaterials.containsKey(iArmorMaterial)) {
                return baseArmorMaterials.get(iArmorMaterial) == baseType;
            }
            return ArmorMaterialBaseType.UNKNOWN == baseType;
        }).collect(Collectors.toList());
    }

    public static ArmorMaterialSyncPacket toPacket(Map<ResourceLocation, IArmorMaterial> map) {
        return new ArmorMaterialSyncPacket(map);
    }
}

