/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.items.gearconfig.MeleeGearConfig;
import com.infamous.dungeons_libraries.items.gearconfig.MeleeGearConfigRegistry;
import com.infamous.dungeons_libraries.items.interfaces.IComboWeapon;
import com.infamous.dungeons_libraries.items.interfaces.IMeleeWeapon;
import com.infamous.dungeons_libraries.items.interfaces.IReloadableGear;
import com.infamous.dungeons_libraries.items.interfaces.IUniqueGear;
import com.infamous.dungeons_libraries.mixin.ItemAccessor;
import com.infamous.dungeons_libraries.utils.DescriptionHelper;
import com.infamous.dungeons_libraries.utils.MojankHelper;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Rarity;
import net.minecraft.item.TieredItem;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;

public class MeleeGear
extends TieredItem
implements IMeleeWeapon,
IComboWeapon,
IVanishable,
IReloadableGear,
IUniqueGear {
    private Multimap<Attribute, AttributeModifier> defaultModifiers;
    private MeleeGearConfig meleeGearConfig;
    private float attackDamage;

    public MeleeGear(Item.Properties properties) {
        super((IItemTier)ItemTier.WOOD, properties);
        this.reload();
    }

    @Override
    public void reload() {
        this.meleeGearConfig = MeleeGearConfigRegistry.getConfig(this.getRegistryName());
        IItemTier material = this.meleeGearConfig.getWeaponMaterial();
        ((ItemAccessor)((Object)this)).setMaxDamage(material.func_200926_a());
        Set<ToolType> toolTypes = ((ItemAccessor)((Object)this)).getToolClasses().keySet();
        toolTypes.forEach(toolType -> ((ItemAccessor)((Object)this)).getToolClasses().put((ToolType)toolType, material.func_200925_d()));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.meleeGearConfig.getAttributes().forEach(attributeModifier -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeModifier.getAttributeResourceLocation());
            if (attribute != null) {
                UUID uuid = UUID.randomUUID();
                if (Attributes.field_233823_f_.equals(attribute)) {
                    uuid = field_111210_e;
                    this.attackDamage = (float)attributeModifier.getAmount() + this.func_200891_e().func_200929_c();
                } else if (Attributes.field_233825_h_.equals(attribute)) {
                    uuid = field_185050_h;
                }
                builder.put((Object)attribute, (Object)new AttributeModifier(uuid, "Weapon modifier", attributeModifier.getAmount(), attributeModifier.getOperation()));
            }
        });
        this.defaultModifiers = builder.build();
    }

    public MeleeGearConfig getGearConfig() {
        return this.meleeGearConfig;
    }

    @Override
    public int getComboLength(ItemStack stack, LivingEntity attacker) {
        return this.getGearConfig().getComboLength();
    }

    @Override
    public boolean isUnique() {
        return this.meleeGearConfig.isUnique();
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlotType.MAINHAND ? this.defaultModifiers : super.func_111205_h(pEquipmentSlot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        DescriptionHelper.addFullDescription(list, stack);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.getGearConfig().isDisablesShield();
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, MojankHelper::hurtEnemyBroadcastBreakEvent);
        if (attacker.func_233638_c_(Attributes.field_233825_h_) >= -1.0) {
            target.field_70172_ad = 0;
        }
        return true;
    }

    public float getDamage() {
        return this.attackDamage;
    }

    public boolean func_195938_a(BlockState pState, World pLevel, BlockPos pPos, PlayerEntity pPlayer) {
        return !pPlayer.func_184812_l_();
    }

    public boolean func_179218_a(ItemStack itemStack, World level, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity) {
        if (blockState.func_185887_b((IBlockReader)level, blockPos) != 0.0f) {
            itemStack.func_222118_a(1, livingEntity, MojankHelper::hurtEnemyBroadcastBreakEvent);
        }
        return true;
    }

    public boolean func_150897_b(BlockState p_150897_1_) {
        return p_150897_1_.func_203425_a(Blocks.field_196553_aF) || p_150897_1_.func_235714_a_((ITag)BlockTags.field_206952_E);
    }

    public float func_150893_a(ItemStack p_150893_1_, BlockState p_150893_2_) {
        if (p_150893_2_.func_203425_a(Blocks.field_196553_aF) || p_150893_2_.func_235714_a_((ITag)BlockTags.field_206952_E)) {
            return 15.0f;
        }
        Material lvt_3_1_ = p_150893_2_.func_185904_a();
        return lvt_3_1_ != Material.field_151585_k && lvt_3_1_ != Material.field_151582_l && lvt_3_1_ != Material.field_151589_v && !p_150893_2_.func_235714_a_((ITag)BlockTags.field_206952_E) && lvt_3_1_ != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public Rarity func_77613_e(ItemStack pStack) {
        return this.getGearConfig().getRarity();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y == EnchantmentType.WEAPON;
    }
}

