/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.event.CrossbowEvent;
import com.infamous.dungeons_libraries.items.gearconfig.BowGearConfig;
import com.infamous.dungeons_libraries.items.gearconfig.CrossbowGearConfigRegistry;
import com.infamous.dungeons_libraries.items.interfaces.IRangedWeapon;
import com.infamous.dungeons_libraries.items.interfaces.IReloadableGear;
import com.infamous.dungeons_libraries.items.interfaces.IUniqueGear;
import com.infamous.dungeons_libraries.mixin.CrossbowItemInvoker;
import com.infamous.dungeons_libraries.mixin.ItemAccessor;
import com.infamous.dungeons_libraries.utils.DescriptionHelper;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class CrossbowGear
extends CrossbowItem
implements IRangedWeapon,
IReloadableGear,
IUniqueGear {
    private Multimap<Attribute, AttributeModifier> defaultModifiers;
    private BowGearConfig crossbowGearConfig;
    public boolean isLoadingStart = false;
    public boolean isLoadingMiddle = false;

    public CrossbowGear(Item.Properties builder) {
        super(builder.func_200918_c(384));
        this.reload();
    }

    @Override
    public void reload() {
        this.crossbowGearConfig = CrossbowGearConfigRegistry.getConfig(this.getRegistryName());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.crossbowGearConfig.getAttributes().forEach(attributeModifier -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeModifier.getAttributeResourceLocation());
            if (attribute != null) {
                UUID uuid = UUID.randomUUID();
                if (Attributes.field_233823_f_.equals(attribute)) {
                    uuid = field_111210_e;
                } else if (Attributes.field_233825_h_.equals(attribute)) {
                    uuid = field_185050_h;
                }
                builder.put((Object)attribute, (Object)new AttributeModifier(uuid, "Weapon modifier", attributeModifier.getAmount(), attributeModifier.getOperation()));
            }
        });
        this.defaultModifiers = builder.build();
        ((ItemAccessor)((Object)this)).setMaxDamage(this.crossbowGearConfig.getDurability());
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlotType.MAINHAND ? this.defaultModifiers : super.func_111205_h(pEquipmentSlot);
    }

    public static float getArrowVelocity(LivingEntity livingEntity, ItemStack stack) {
        float baseVelocity = 3.15f;
        if (CrossbowGear.func_220019_a((ItemStack)stack, (Item)Items.field_196152_dE)) {
            baseVelocity = 1.6f;
        }
        CrossbowEvent.Velocity event = new CrossbowEvent.Velocity(livingEntity, stack, baseVelocity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getVelocity();
    }

    public static float[] getRandomSoundPitches(Random rand) {
        boolean flag = rand.nextBoolean();
        return new float[]{1.0f, CrossbowGear.getRandomSoundPitch(flag), CrossbowGear.getRandomSoundPitch(!flag)};
    }

    private static float getRandomSoundPitch(boolean flagIn) {
        float f = flagIn ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static boolean canAddChargedProjectile(LivingEntity livingEntity, ItemStack stack, ItemStack stack1, boolean b, boolean b1) {
        ItemStack itemstack;
        boolean flag;
        if (stack1.func_190926_b()) {
            return false;
        }
        boolean bl = flag = b1 && stack1.func_77973_b() instanceof ArrowItem;
        if (!(flag || b1 || b)) {
            itemstack = stack1.func_77979_a(1);
            if (stack1.func_190926_b() && livingEntity instanceof PlayerEntity) {
                ((PlayerEntity)livingEntity).field_71071_by.func_184437_d(stack1);
            }
        } else {
            itemstack = stack1.func_77946_l();
        }
        CrossbowItemInvoker.addChargedProjectile(stack, itemstack);
        return true;
    }

    public float getDefaultChargeTime() {
        return this.crossbowGearConfig.getDefaultChargeTime();
    }

    public void func_219972_a(World world, LivingEntity livingEntity, ItemStack stack, int timeLeft) {
        if (!world.field_72995_K) {
            int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
            SoundEvent quickChargeSoundEvent = this.getCrossbowSoundEvent(quickChargeLevel);
            SoundEvent loadingMiddleSoundEvent = quickChargeLevel == 0 ? SoundEvents.field_219611_bC : null;
            float chargeTime = (float)(stack.func_77988_m() - timeLeft) / this.getCrossbowChargeTime(livingEntity, stack);
            if (chargeTime < 0.2f) {
                this.isLoadingStart = false;
                this.isLoadingMiddle = false;
            }
            if (chargeTime >= 0.2f && !this.isLoadingStart && chargeTime < 1.0f) {
                this.isLoadingStart = true;
                world.func_184148_a((PlayerEntity)null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), quickChargeSoundEvent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (chargeTime >= 0.5f && loadingMiddleSoundEvent != null && !this.isLoadingMiddle && chargeTime < 1.0f) {
                this.isLoadingMiddle = true;
                world.func_184148_a((PlayerEntity)null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), loadingMiddleSoundEvent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity livingEntity, int timeLeft) {
        float i = this.getCrossbowChargeTime(livingEntity, stack) + 3.0f - (float)timeLeft;
        float f = this.getCrossbowCharge(livingEntity, i, stack);
        if (f >= 1.0f && !CrossbowGear.func_220012_d((ItemStack)stack) && CrossbowGear.hasAmmo(livingEntity, stack)) {
            CrossbowGear.func_220011_a((ItemStack)stack, (boolean)true);
            SoundCategory soundcategory = livingEntity instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            worldIn.func_184148_a((PlayerEntity)null, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public float getCrossbowCharge(LivingEntity livingEntity, float useTime, ItemStack stack) {
        float crossbowChargeTime = this.getCrossbowChargeTime(livingEntity, stack);
        float f = useTime / crossbowChargeTime;
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public float getCrossbowChargeTime(LivingEntity livingEntity, ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        float minTime = 1.0f;
        CrossbowEvent.ChargeTime event = new CrossbowEvent.ChargeTime(livingEntity, stack, this.getDefaultChargeTime());
        MinecraftForge.EVENT_BUS.post((Event)event);
        return Math.max(event.getChargeTime() - (float)(5 * quickChargeLevel), minTime);
    }

    public SoundEvent getCrossbowSoundEvent(int i) {
        switch (i) {
            case 1: {
                return SoundEvents.field_219613_bE;
            }
            case 2: {
                return SoundEvents.field_219614_bF;
            }
            case 3: {
                return SoundEvents.field_219615_bG;
            }
        }
        return SoundEvents.field_219612_bD;
    }

    public void fireCrossbowProjectiles(World world, LivingEntity livingEntity, Hand hand, ItemStack stack, float velocityIn, float inaccuracyIn) {
        List<ItemStack> list = CrossbowItemInvoker.getChargedProjectiles(stack);
        float[] randomSoundPitches = CrossbowGear.getRandomSoundPitches(livingEntity.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean playerInCreativeMode;
            ItemStack currentProjectile = list.get(i);
            boolean bl = playerInCreativeMode = livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75098_d;
            if (currentProjectile.func_190926_b()) continue;
            if (i == 0) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 0.0f);
                continue;
            }
            if (i == 1) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, -10.0f);
                continue;
            }
            if (i == 2) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i], playerInCreativeMode, velocityIn, inaccuracyIn, 10.0f);
                continue;
            }
            if (i == 3) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, -20.0f);
                continue;
            }
            if (i == 4) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 2], playerInCreativeMode, velocityIn, inaccuracyIn, 20.0f);
                continue;
            }
            if (i == 5) {
                this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, -30.0f);
                continue;
            }
            if (i != 6) continue;
            this.fireProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[i - 4], playerInCreativeMode, velocityIn, inaccuracyIn, 30.0f);
        }
        CrossbowItemInvoker.onCrossbowShot(world, livingEntity, stack);
    }

    private AbstractArrowEntity createCrossbowArrow(World world, LivingEntity livingEntity, ItemStack stack, ItemStack stack1) {
        ArrowItem arrowItem = (ArrowItem)(stack1.func_77973_b() instanceof ArrowItem ? stack1.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractArrowEntity = arrowItem.func_200887_a(world, stack1, livingEntity);
        ModifiableAttributeInstance attribute = livingEntity.func_110148_a((Attribute)AttributeRegistry.RANGED_DAMAGE_MULTIPLIER.get());
        if (attribute != null) {
            abstractArrowEntity.func_70239_b(abstractArrowEntity.func_70242_d() * attribute.func_111126_e());
        }
        if (livingEntity instanceof PlayerEntity) {
            abstractArrowEntity.func_70243_d(true);
        }
        abstractArrowEntity.func_213869_a(SoundEvents.field_219609_bA);
        abstractArrowEntity.func_213865_o(true);
        int piercingLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)stack);
        if (piercingLevel > 0) {
            abstractArrowEntity.func_213872_b((byte)piercingLevel);
        }
        int powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
        if (this.shootsHeavyArrows(stack)) {
            ++powerLevel;
        }
        if (powerLevel > 0) {
            abstractArrowEntity.func_70239_b(abstractArrowEntity.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
        }
        int punchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
        if (this.shootsHeavyArrows(stack)) {
            ++punchLevel;
        }
        if (punchLevel > 0) {
            abstractArrowEntity.func_70240_a(punchLevel);
        }
        return abstractArrowEntity;
    }

    public int func_77626_a(ItemStack stack) {
        return (int)this.getCrossbowChargeTime(null, stack) + 3;
    }

    public Rarity func_77613_e(ItemStack pStack) {
        return this.getGearConfig().getRarity();
    }

    public boolean func_219970_i(ItemStack stack) {
        return true;
    }

    public void fireProjectile(World worldIn, LivingEntity shooter, Hand handIn, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle) {
        if (!worldIn.field_72995_K) {
            AbstractArrowEntity projectileentity;
            boolean flag;
            boolean bl = flag = projectile.func_77973_b() == Items.field_196152_dE;
            if (flag) {
                projectileentity = new FireworkRocketEntity(worldIn, projectile, (Entity)shooter, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.15f, shooter.func_226281_cx_(), true);
            } else {
                projectileentity = this.createCrossbowArrow(worldIn, shooter, crossbow, projectile);
                if (isCreativeMode || projectileAngle != 0.0f) {
                    projectileentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof ICrossbowUser) {
                ICrossbowUser icrossbowuser = (ICrossbowUser)shooter;
                icrossbowuser.func_230284_a_(Objects.requireNonNull(icrossbowuser.func_70638_az()), crossbow, (ProjectileEntity)projectileentity, projectileAngle);
            } else {
                Vector3d vector3d1 = shooter.func_213286_i(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vector3d1), projectileAngle, true);
                Vector3d vector3d = shooter.func_70676_i(1.0f);
                Vector3f vector3f = new Vector3f(vector3d);
                vector3f.func_214905_a(quaternion);
                projectileentity.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), velocity, inaccuracy);
            }
            this.damageItem(flag ? 3 : 1, crossbow, shooter, handIn);
            worldIn.func_217376_c((Entity)projectileentity);
            worldIn.func_184148_a((PlayerEntity)null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, soundPitch);
        }
    }

    protected void damageItem(int amount, ItemStack crossbow, LivingEntity shooter, Hand handIn) {
        crossbow.func_222118_a(amount, shooter, p_220017_1_ -> p_220017_1_.func_213334_d(handIn));
    }

    protected static boolean hasAmmo(LivingEntity entityIn, ItemStack stack) {
        int multishotLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack);
        CrossbowGear adci = (CrossbowGear)stack.func_77973_b();
        if (adci.hasExtraMultishot(stack)) {
            ++multishotLevel;
        }
        int arrowsToFire = 1 + multishotLevel * 2;
        boolean flag = entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d;
        ItemStack itemstack = entityIn.func_213356_f(stack);
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int i = 0; i < arrowsToFire; ++i) {
            if (i > 0) {
                itemstack = itemstack1.func_77946_l();
            }
            if (itemstack.func_190926_b() && flag) {
                itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                itemstack1 = itemstack.func_77946_l();
            }
            if (CrossbowGear.canAddChargedProjectile(entityIn, stack, itemstack, i > 0, flag)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnique() {
        return this.crossbowGearConfig.isUnique();
    }

    public BowGearConfig getGearConfig() {
        return this.crossbowGearConfig;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        DescriptionHelper.addFullDescription(list, stack);
    }
}

