/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.items.gearconfig.BowGearConfig;
import com.infamous.dungeons_libraries.items.gearconfig.BowGearConfigRegistry;
import com.infamous.dungeons_libraries.items.interfaces.IRangedWeapon;
import com.infamous.dungeons_libraries.items.interfaces.IReloadableGear;
import com.infamous.dungeons_libraries.items.interfaces.IUniqueGear;
import com.infamous.dungeons_libraries.mixin.ItemAccessor;
import com.infamous.dungeons_libraries.utils.DescriptionHelper;
import com.infamous.dungeons_libraries.utils.RangedAttackHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class BowGear
extends BowItem
implements IRangedWeapon,
IReloadableGear,
IUniqueGear {
    private Multimap<Attribute, AttributeModifier> defaultModifiers;
    private BowGearConfig bowGearConfig;

    public BowGear(Item.Properties builder) {
        super(builder.func_200918_c(384));
        this.reload();
    }

    @Override
    public void reload() {
        this.bowGearConfig = BowGearConfigRegistry.getConfig(this.getRegistryName());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.bowGearConfig.getAttributes().forEach(attributeModifier -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeModifier.getAttributeResourceLocation());
            if (attribute != null) {
                UUID uuid = UUID.randomUUID();
                if (Attributes.field_233823_f_.equals(attribute)) {
                    uuid = field_111210_e;
                } else if (Attributes.field_233825_h_.equals(attribute)) {
                    uuid = field_185050_h;
                }
                builder.put((Object)attribute, (Object)new AttributeModifier(uuid, "Weapon modifier", attributeModifier.getAmount(), attributeModifier.getOperation()));
            }
        });
        this.defaultModifiers = builder.build();
        ((ItemAccessor)((Object)this)).setMaxDamage(this.bowGearConfig.getDurability());
    }

    public float getDefaultChargeTime() {
        return this.bowGearConfig.getDefaultChargeTime();
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlotType.MAINHAND ? this.defaultModifiers : super.func_111205_h(pEquipmentSlot);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity livingEntity, int timeLeft) {
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)livingEntity;
            boolean useInfiniteAmmo = playerentity.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = playerentity.func_213356_f(stack);
            int charge = this.func_77626_a(stack) - timeLeft;
            if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (PlayerEntity)playerentity, (int)charge, (!itemstack.func_190926_b() || useInfiniteAmmo ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.func_190926_b() || useInfiniteAmmo) {
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                float arrowVelocity = RangedAttackHelper.getArrowVelocity((LivingEntity)playerentity, stack, charge);
                this.fireArrows(stack, world, playerentity, itemstack, arrowVelocity);
            }
        }
    }

    public void fireArrows(ItemStack stack, World world, PlayerEntity playerentity, ItemStack itemstack, float arrowVelocity) {
        int multishotLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack);
        int arrowsToFire = 1;
        if (multishotLevel > 0) {
            arrowsToFire += 2;
        }
        if (this.hasMultishotWhenCharged(stack) && arrowVelocity == 1.0f) {
            arrowsToFire += 2;
        }
        for (int arrowNumber = 0; arrowNumber < arrowsToFire; ++arrowNumber) {
            boolean isAdditionalShot;
            if (!((double)arrowVelocity >= 0.1)) continue;
            boolean hasInfiniteAmmo = playerentity.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ArrowItem && ((ArrowItem)itemstack.func_77973_b()).isInfinite(itemstack, stack, playerentity);
            boolean bl = isAdditionalShot = arrowNumber > 0;
            if (!world.field_72995_K) {
                this.createBowArrow(stack, world, playerentity, itemstack, arrowVelocity, arrowNumber, hasInfiniteAmmo, isAdditionalShot);
            }
            world.func_184148_a((PlayerEntity)null, playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
            if (!(hasInfiniteAmmo || playerentity.field_71075_bZ.field_75098_d || isAdditionalShot)) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    playerentity.field_71071_by.func_184437_d(itemstack);
                }
            }
            playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
    }

    public AbstractArrowEntity createBowArrow(ItemStack stack, World world, PlayerEntity playerentity, ItemStack itemstack, float arrowVelocity, int i, boolean hasInfiniteAmmo, boolean isAdditionalShot) {
        int punchLevel;
        ArrowItem arrowitem = (ArrowItem)(itemstack.func_77973_b() instanceof ArrowItem ? itemstack.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractArrowEntity = arrowitem.func_200887_a(world, itemstack, (LivingEntity)playerentity);
        abstractArrowEntity = this.customArrow(abstractArrowEntity);
        ModifiableAttributeInstance attribute = playerentity.func_110148_a((Attribute)AttributeRegistry.RANGED_DAMAGE_MULTIPLIER.get());
        if (attribute != null) {
            abstractArrowEntity.func_70239_b(abstractArrowEntity.func_70242_d() * attribute.func_111126_e());
        }
        this.setArrowTrajectory(playerentity, arrowVelocity, i, abstractArrowEntity);
        if (arrowVelocity == 1.0f) {
            abstractArrowEntity.func_70243_d(true);
        }
        int powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
        if (this.shootsHeavyArrows(stack)) {
            ++powerLevel;
        }
        if (powerLevel > 0) {
            abstractArrowEntity.func_70239_b(abstractArrowEntity.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
        }
        if ((punchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
            abstractArrowEntity.func_70240_a(punchLevel);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
            abstractArrowEntity.func_70015_d(100);
        }
        stack.func_222118_a(1, (LivingEntity)playerentity, p_lambda$onPlayerStoppedUsing$0_1_ -> p_lambda$onPlayerStoppedUsing$0_1_.func_213334_d(playerentity.func_184600_cs()));
        if (hasInfiniteAmmo || playerentity.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
            abstractArrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
        }
        if (isAdditionalShot) {
            abstractArrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
        }
        world.func_217376_c((Entity)abstractArrowEntity);
        return abstractArrowEntity;
    }

    public void setArrowTrajectory(PlayerEntity playerentity, float arrowVelocity, int i, AbstractArrowEntity abstractarrowentity) {
        if (i == 0) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 1) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z + 10.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 2) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z - 10.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 3) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z + 20.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 4) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z - 20.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 5) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z + 30.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
        if (i == 6) {
            abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z - 30.0f, 0.0f, arrowVelocity * 3.0f, 1.0f);
        }
    }

    public Rarity func_77613_e(ItemStack pStack) {
        return this.getGearConfig().getRarity();
    }

    @Override
    public boolean isUnique() {
        return this.bowGearConfig.isUnique();
    }

    public BowGearConfig getGearConfig() {
        return this.bowGearConfig;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        DescriptionHelper.addFullDescription(list, stack);
    }
}

