/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.infamous.dungeons_libraries.data.Codecs;
import com.infamous.dungeons_libraries.items.gearconfig.GearConfigAttributeModifier;
import com.infamous.dungeons_libraries.items.materials.armor.ArmorMaterials;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;

public class ArmorGearConfig {
    public static final ArmorGearConfig DEFAULT = new ArmorGearConfig(new ArrayList<GearConfigAttributeModifier>(), new ArrayList<EnchantmentData>(), new ResourceLocation("minecraft:iron"), false, Rarity.COMMON);
    public static final Codec<ArmorGearConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GearConfigAttributeModifier.CODEC.listOf().optionalFieldOf("attributes", new ArrayList()).forGetter(ArmorGearConfig::getAttributes), (App)Codecs.ENCHANTMENT_DATA_CODEC.listOf().optionalFieldOf("built_in_enchantments", new ArrayList()).forGetter(ArmorGearConfig::getBuiltInEnchantments), (App)ResourceLocation.field_240908_a_.fieldOf("material").forGetter(armorGearConfig -> armorGearConfig.materialResource), (App)Codec.BOOL.optionalFieldOf("unique", (Object)false).forGetter(ArmorGearConfig::isUnique), (App)Codecs.ITEM_RARITY_CODEC.fieldOf("rarity").forGetter(ArmorGearConfig::getRarity)).apply((Applicative)instance, ArmorGearConfig::new));
    private List<GearConfigAttributeModifier> attributes;
    private List<EnchantmentData> builtInEnchantments;
    private ResourceLocation materialResource;
    private boolean unique;
    private Rarity rarity;

    public ArmorGearConfig(List<GearConfigAttributeModifier> attributes, List<EnchantmentData> builtInEnchantments, ResourceLocation materialResource, boolean unique, Rarity rarity) {
        this.attributes = attributes;
        this.builtInEnchantments = builtInEnchantments;
        this.materialResource = materialResource;
        this.unique = unique;
        this.rarity = rarity;
    }

    public List<GearConfigAttributeModifier> getAttributes() {
        return this.attributes;
    }

    public List<EnchantmentData> getBuiltInEnchantments() {
        return this.builtInEnchantments;
    }

    public IArmorMaterial getArmorMaterial() {
        return ArmorMaterials.getArmorMaterial(this.materialResource);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public Rarity getRarity() {
        return this.rarity;
    }
}

