/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorGearConfig;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorGearConfigRegistry;
import com.infamous.dungeons_libraries.items.interfaces.IArmor;
import com.infamous.dungeons_libraries.items.interfaces.IReloadableGear;
import com.infamous.dungeons_libraries.items.interfaces.IUniqueGear;
import com.infamous.dungeons_libraries.mixin.ArmorItemAccessor;
import com.infamous.dungeons_libraries.mixin.ItemAccessor;
import com.infamous.dungeons_libraries.utils.DescriptionHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;

public class ArmorGear
extends GeoArmorItem
implements IReloadableGear,
IArmor,
IUniqueGear,
IAnimatable {
    private static final ResourceLocation DEFAULT_ARMOR_ANIMATIONS = new ResourceLocation("dungeons_libraries", "animations/armor/armor_default.animation.json");
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private Multimap<Attribute, AttributeModifier> defaultModifiers;
    private ArmorGearConfig armorGearConfig;
    private ResourceLocation texture;
    private ResourceLocation armorSet;
    private ResourceLocation modelLocation;
    private ResourceLocation textureLocation;
    private ResourceLocation animationFileLocation;
    protected AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ArmorGear(EquipmentSlotType slotType, Item.Properties properties, ResourceLocation armorSet, ResourceLocation modelLocation, ResourceLocation textureLocation, ResourceLocation animationFileLocation) {
        super((IArmorMaterial)ArmorMaterial.CHAIN, slotType, properties);
        this.armorSet = armorSet;
        this.modelLocation = modelLocation;
        this.textureLocation = textureLocation;
        this.animationFileLocation = animationFileLocation;
        this.reload();
    }

    @Override
    public void reload() {
        this.armorGearConfig = ArmorGearConfigRegistry.getConfig(this.armorSet);
        if (this.armorGearConfig == ArmorGearConfig.DEFAULT) {
            this.armorGearConfig = ArmorGearConfigRegistry.getConfig(this.getRegistryName());
        }
        IArmorMaterial material = this.armorGearConfig.getArmorMaterial();
        ((ArmorItemAccessor)((Object)this)).setMaterial(material);
        ((ArmorItemAccessor)((Object)this)).setDefense(material.func_200902_b(this.field_77881_a));
        ((ArmorItemAccessor)((Object)this)).setToughness(material.func_200901_e());
        ((ArmorItemAccessor)((Object)this)).setKnockbackResistance(material.func_230304_f_());
        ((ItemAccessor)((Object)this)).setMaxDamage(material.func_200896_a(this.field_77881_a));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID primaryUuid = ARMOR_MODIFIER_UUID_PER_SLOT[this.field_77881_a.func_188454_b()];
        builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(primaryUuid, "Armor modifier", (double)material.func_200902_b(this.field_77881_a), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(primaryUuid, "Armor toughness", (double)material.func_200901_e(), AttributeModifier.Operation.ADDITION));
        if (this.field_234655_c_ > 0.0f) {
            builder.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(primaryUuid, "Armor knockback resistance", (double)this.field_234655_c_, AttributeModifier.Operation.ADDITION));
        }
        this.armorGearConfig.getAttributes().forEach(attributeModifier -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeModifier.getAttributeResourceLocation());
            if (attribute != null) {
                UUID uuid = UUID.randomUUID();
                builder.put((Object)attribute, (Object)new AttributeModifier(uuid, "Armor modifier", attributeModifier.getAmount(), attributeModifier.getOperation()));
            }
        });
        this.defaultModifiers = builder.build();
    }

    public ArmorGearConfig getGearConfig() {
        return this.armorGearConfig;
    }

    @Override
    public boolean isUnique() {
        return this.armorGearConfig.isUnique();
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType pEquipmentSlot) {
        return pEquipmentSlot == this.field_77881_a ? this.defaultModifiers : super.func_111205_h(pEquipmentSlot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        if (this.armorSet != null) {
            DescriptionHelper.addLoreDescription(list, this.armorSet);
        } else {
            DescriptionHelper.addLoreDescription(list, this.getRegistryName());
        }
    }

    public Rarity func_77613_e(ItemStack pStack) {
        return this.getGearConfig().getRarity();
    }

    public ResourceLocation getArmorSet() {
        return this.armorSet;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public ResourceLocation getModelLocation() {
        return this.modelLocation;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public ResourceLocation getAnimationFileLocation() {
        return this.animationFileLocation;
    }
}

