/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.artifacts;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.client.TooltipHelper;
import com.infamous.dungeons_libraries.config.DungeonsLibrariesConfig;
import com.infamous.dungeons_libraries.event.ArtifactEvent;
import com.infamous.dungeons_libraries.items.ItemTagWrappers;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactUseContext;
import com.infamous.dungeons_libraries.mixin.CooldownAccessor;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class ArtifactItem
extends Item
implements ICurioItem {
    protected final UUID SLOT0_UUID = UUID.fromString("7037798e-ac2c-4711-aa72-ba73589f1411");
    protected final UUID SLOT1_UUID = UUID.fromString("1906bae9-9f26-4194-bb8a-ef95b8cad134");
    protected final UUID SLOT2_UUID = UUID.fromString("b99aa930-03d0-4b2d-aa69-7b5d943dd75c");
    protected boolean procOnItemUse = false;

    public ArtifactItem(Item.Properties properties) {
        super(properties.func_200918_c(((Integer)DungeonsLibrariesConfig.ARTIFACT_DURABILITY.get()).intValue()));
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public static void putArtifactOnCooldown(PlayerEntity playerIn, Item item) {
        int cooldownInTicks = item instanceof ArtifactItem ? ((ArtifactItem)item).getCooldownInSeconds() * 20 : 0;
        ModifiableAttributeInstance artifactCooldownMultiplierAttribute = playerIn.func_110148_a((Attribute)AttributeRegistry.ARTIFACT_COOLDOWN_MULTIPLIER.get());
        double attributeModifier = artifactCooldownMultiplierAttribute != null ? artifactCooldownMultiplierAttribute.func_111126_e() : 1.0;
        playerIn.func_184811_cZ().func_185145_a(item, Math.max(0, (int)((double)cooldownInTicks * attributeModifier)));
    }

    public static void triggerSynergy(PlayerEntity player, ItemStack stack) {
        ArtifactEvent.Activated event = new ArtifactEvent.Activated((LivingEntity)player, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void reduceArtifactCooldowns(PlayerEntity playerEntity, double reductionInSeconds) {
        for (Item item : playerEntity.func_184811_cZ().field_185147_a.keySet()) {
            if (!(item instanceof ArtifactItem)) continue;
            int createTicks = ((CooldownAccessor)playerEntity.func_184811_cZ().field_185147_a.get(item)).getStartTime();
            int expireTicks = ((CooldownAccessor)playerEntity.func_184811_cZ().field_185147_a.get(item)).getEndTime();
            int duration = expireTicks - createTicks;
            playerEntity.func_184811_cZ().func_185145_a(item, Math.max(0, duration - (int)(reductionInSeconds * 20.0)));
        }
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        return Rarity.RARE;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ItemTagWrappers.ARTIFACT_REPAIR_ITEMS.func_230235_a_((Object)repair.func_77973_b()) || super.func_82789_a(toRepair, repair);
    }

    public ActionResult<ItemStack> activateArtifact(ArtifactUseContext artifactUseContext) {
        ActionResult<ItemStack> procResult;
        if (artifactUseContext.getPlayer() != null) {
            ItemStack itemStack = artifactUseContext.getItemStack();
            if (artifactUseContext.getPlayer().func_184811_cZ().func_185141_a(itemStack.func_77973_b())) {
                return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
            }
        }
        if ((procResult = this.procArtifact(artifactUseContext)).func_188397_a().func_226246_a_() && artifactUseContext.getPlayer() != null && !artifactUseContext.getLevel().field_72995_K) {
            ArtifactItem.triggerSynergy(artifactUseContext.getPlayer(), artifactUseContext.getItemStack());
        }
        return procResult;
    }

    public abstract ActionResult<ItemStack> procArtifact(ArtifactUseContext var1);

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        TooltipHelper.addFullArtifactDescription(list, stack);
    }

    public abstract int getCooldownInSeconds();

    public abstract int getDurationInSeconds();

    public void stopUsingArtifact(LivingEntity livingEntity) {
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(int slotIndex) {
        return ImmutableMultimap.of();
    }

    public int func_77619_b() {
        return 9;
    }

    protected UUID getUUIDForSlot(int slotIndex) {
        switch (slotIndex) {
            case 0: {
                return this.SLOT0_UUID;
            }
            case 1: {
                return this.SLOT1_UUID;
            }
            case 2: {
                return this.SLOT2_UUID;
            }
        }
        return this.SLOT2_UUID;
    }
}

