/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.artifacts;

import com.infamous.dungeons_libraries.capabilities.artifact.ArtifactUsageHelper;
import com.infamous.dungeons_libraries.capabilities.artifact.IArtifactUsage;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class ArtifactEvents {
    @SubscribeEvent
    public static void onCurioChange(CurioChangeEvent event) {
        ItemStack itemstack1;
        if (!event.getIdentifier().equals("artifact")) {
            return;
        }
        ItemStack itemstack = event.getTo();
        if (itemstack.func_77973_b() instanceof ArtifactItem && !itemstack.func_190926_b()) {
            event.getEntityLiving().func_233645_dx_().func_233793_b_(((ArtifactItem)itemstack.func_77973_b()).getDefaultAttributeModifiers(event.getSlotIndex()));
        }
        if ((itemstack1 = event.getFrom()).func_77973_b() instanceof ArtifactItem && !itemstack1.func_190926_b()) {
            event.getEntityLiving().func_233645_dx_().func_233785_a_(((ArtifactItem)itemstack1.func_77973_b()).getDefaultAttributeModifiers(event.getSlotIndex()));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        IArtifactUsage cap = ArtifactUsageHelper.getArtifactUsageCapability((Entity)event.player);
        if (cap != null && cap.isUsingArtifact() && cap.getUsingArtifact().func_77973_b() instanceof ArtifactItem) {
            cap.getUsingArtifact().func_77973_b().func_219972_a(event.player.field_70170_p, (LivingEntity)event.player, cap.getUsingArtifact(), cap.getUsingArtifactRemaining());
            cap.setUsingArtifactRemaining(cap.getUsingArtifactRemaining() - 1);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ArtifactEvents.stopUsingAllArtifacts(event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        ArtifactEvents.stopUsingAllArtifacts(event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        ArtifactEvents.stopUsingAllArtifacts(event.getPlayer());
    }

    private static void stopUsingAllArtifacts(PlayerEntity player) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
            Optional artifactStackHandler = iCuriosItemHandler.getStacksHandler("artifact");
            if (artifactStackHandler.isPresent()) {
                int slots = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getSlots();
                for (int slot = 0; slot < slots; ++slot) {
                    ItemStack artifact = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getStackInSlot(slot);
                    if (artifact.func_190926_b() || !(artifact.func_77973_b() instanceof ArtifactItem)) continue;
                    ((ArtifactItem)artifact.func_77973_b()).stopUsingArtifact((LivingEntity)player);
                }
            }
        });
    }
}

