/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items;

import com.infamous.dungeons_libraries.items.gearconfig.CrossbowGear;
import com.infamous.dungeons_libraries.utils.RangedAttackHelper;
import java.util.Map;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class RangedItemModelProperties {
    private static final ResourceLocation PULL_PROPERTY = new ResourceLocation("pull");
    private static final ResourceLocation PULLING_PROPERTY = new ResourceLocation("pulling");
    private static final ResourceLocation CHARGED_PROPERTY = new ResourceLocation("charged");

    public static void init() {
        Map itemModelsProperties = ItemModelsProperties.field_239415_f_;
        Map bowModelProperties = (Map)itemModelsProperties.get(Items.field_151031_f);
        bowModelProperties.put(PULL_PROPERTY, RangedItemModelProperties::getBowPullProperty);
        bowModelProperties.put(PULLING_PROPERTY, RangedItemModelProperties::getBowPullingProperty);
        Map crossbowModelProperties = (Map)itemModelsProperties.get(Items.field_222114_py);
        crossbowModelProperties.put(PULL_PROPERTY, RangedItemModelProperties::getCrossbowPullProperty);
        crossbowModelProperties.put(PULLING_PROPERTY, RangedItemModelProperties::getCrossbowPullingProperty);
        crossbowModelProperties.put(CHARGED_PROPERTY, RangedItemModelProperties::getCrossbowChargedProperty);
    }

    public static void addRangedModelProperties(RegistryObject<Item> itemRegistryObject) {
        if (itemRegistryObject.get() instanceof BowItem) {
            RangedItemModelProperties.addBowModelProperties(itemRegistryObject);
        } else if (itemRegistryObject.get() instanceof CrossbowItem) {
            RangedItemModelProperties.addCrossbowModelProperties(itemRegistryObject);
        }
    }

    public static void addBowModelProperties(RegistryObject<Item> itemRegistryObject) {
        ItemModelsProperties.func_239418_a_((Item)((Item)itemRegistryObject.get()), (ResourceLocation)PULL_PROPERTY, RangedItemModelProperties::getBowPullProperty);
        ItemModelsProperties.func_239418_a_((Item)((Item)itemRegistryObject.get()), (ResourceLocation)PULLING_PROPERTY, RangedItemModelProperties::getBowPullingProperty);
    }

    public static void addCrossbowModelProperties(RegistryObject<Item> itemRegistryObject) {
        ItemModelsProperties.func_239418_a_((Item)((Item)itemRegistryObject.get()), (ResourceLocation)PULL_PROPERTY, RangedItemModelProperties::getCrossbowPullProperty);
        ItemModelsProperties.func_239418_a_((Item)((Item)itemRegistryObject.get()), (ResourceLocation)PULLING_PROPERTY, RangedItemModelProperties::getCrossbowPullingProperty);
        ItemModelsProperties.func_239418_a_((Item)((Item)itemRegistryObject.get()), (ResourceLocation)CHARGED_PROPERTY, RangedItemModelProperties::getCrossbowChargedProperty);
    }

    private static float getCrossbowPullProperty(ItemStack stack, ClientWorld clientWorld, LivingEntity livingEntity) {
        if (livingEntity == null || CrossbowItem.func_220012_d((ItemStack)stack)) {
            return 0.0f;
        }
        if (stack.func_77973_b() instanceof CrossbowGear) {
            return (float)(stack.func_77988_m() - livingEntity.func_184605_cv()) / RangedAttackHelper.getModdedCrossbowChargeTime(livingEntity, stack);
        }
        return CrossbowItem.func_220012_d((ItemStack)stack) ? 0.0f : (float)(stack.func_77988_m() - livingEntity.func_184605_cv()) / RangedAttackHelper.getVanillaCrossbowChargeTime(livingEntity, stack);
    }

    private static float getCrossbowPullingProperty(ItemStack stack, ClientWorld clientWorld, LivingEntity livingEntity) {
        return livingEntity != null && livingEntity.func_184587_cr() && livingEntity.func_184607_cu() == stack && !CrossbowItem.func_220012_d((ItemStack)stack) ? 1.0f : 0.0f;
    }

    private static float getCrossbowChargedProperty(ItemStack stack, ClientWorld clientWorld, LivingEntity livingEntity) {
        return livingEntity != null && CrossbowItem.func_220012_d((ItemStack)stack) ? 1.0f : 0.0f;
    }

    private static float getBowPullProperty(ItemStack stack, ClientWorld clientWorld, LivingEntity livingEntity) {
        if (livingEntity == null || livingEntity.func_184607_cu() != stack) {
            return 0.0f;
        }
        return (float)(stack.func_77988_m() - livingEntity.func_184605_cv()) / RangedAttackHelper.getBowChargeTime(livingEntity, livingEntity.func_184607_cu());
    }

    private static float getBowPullingProperty(ItemStack stack, ClientWorld clientWorld, LivingEntity livingEntity) {
        return livingEntity != null && livingEntity.func_184587_cr() && livingEntity.func_184607_cu() == stack ? 1.0f : 0.0f;
    }
}

