/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.integration.curios.client.message;

import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactUseContext;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosArtifactStartMessage {
    private final int slot;
    private BlockRayTraceResult hitResult;

    public CuriosArtifactStartMessage(int slot, BlockRayTraceResult hitResult) {
        this.slot = slot;
        this.hitResult = hitResult;
    }

    public static void encode(CuriosArtifactStartMessage packet, PacketBuffer buf) {
        buf.writeInt(packet.slot);
        buf.func_218668_a(packet.hitResult);
    }

    public static CuriosArtifactStartMessage decode(PacketBuffer buf) {
        return new CuriosArtifactStartMessage(buf.readInt(), buf.func_218669_q());
    }

    public static class CuriosArtifactHandler {
        public static void handle(CuriosArtifactStartMessage packet, Supplier<NetworkEvent.Context> ctx) {
            if (packet != null) {
                ctx.get().setPacketHandled(true);
                ctx.get().enqueueWork(() -> {
                    ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (player != null) {
                        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
                            ItemStack artifact;
                            Optional artifactStackHandler = iCuriosItemHandler.getStacksHandler("artifact");
                            if (artifactStackHandler.isPresent() && !(artifact = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getStackInSlot(packet.slot)).func_190926_b() && artifact.func_77973_b() instanceof ArtifactItem) {
                                ArtifactUseContext iuc = new ArtifactUseContext(player.field_70170_p, (PlayerEntity)player, artifact, packet.hitResult);
                                ((ArtifactItem)artifact.func_77973_b()).activateArtifact(iuc);
                            }
                        });
                    }
                });
            }
        }
    }
}

