/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.integration.curios.client;

import com.infamous.dungeons_libraries.integration.curios.client.message.CuriosArtifactStartMessage;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactUseContext;
import com.infamous.dungeons_libraries.network.NetworkHandler;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(modid="dungeons_libraries", value={Dist.CLIENT})
public class CuriosKeyBindings {
    private static final double RAYTRACE_DISTANCE = 30.0;
    public static final KeyBinding activateArtifact1 = new KeyBinding("key.dungeons_libraries.curiosintegration.description_slot1", 86, "key.dungeons_libraries.curiosintegration.category");
    public static final KeyBinding activateArtifact2 = new KeyBinding("key.dungeons_libraries.curiosintegration.description_slot2", 66, "key.dungeons_libraries.curiosintegration.category");
    public static final KeyBinding activateArtifact3 = new KeyBinding("key.dungeons_libraries.curiosintegration.description_slot3", 78, "key.dungeons_libraries.curiosintegration.category");

    public static void setupCuriosKeybindings() {
        activateArtifact1.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        ClientRegistry.registerKeyBinding((KeyBinding)activateArtifact1);
        activateArtifact2.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        ClientRegistry.registerKeyBinding((KeyBinding)activateArtifact2);
        activateArtifact3.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        ClientRegistry.registerKeyBinding((KeyBinding)activateArtifact3);
    }

    @SubscribeEvent
    public static void onClientTick(InputEvent.KeyInputEvent event) {
        if (activateArtifact1.func_151468_f()) {
            CuriosKeyBindings.sendCuriosStartMessageToServer(0);
        }
        if (activateArtifact2.func_151468_f()) {
            CuriosKeyBindings.sendCuriosStartMessageToServer(1);
        }
        if (activateArtifact3.func_151468_f()) {
            CuriosKeyBindings.sendCuriosStartMessageToServer(2);
        }
    }

    private static void sendCuriosStartMessageToServer(int slot) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
                BlockRayTraceResult blockRayTraceResult;
                ItemStack artifact;
                Optional artifactStackHandler = iCuriosItemHandler.getStacksHandler("artifact");
                if (artifactStackHandler.isPresent() && !(artifact = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getStackInSlot(slot)).func_190926_b() && artifact.func_77973_b() instanceof ArtifactItem && (blockRayTraceResult = CuriosKeyBindings.getBlockRayTraceResult(player)) != null) {
                    NetworkHandler.INSTANCE.sendToServer((Object)new CuriosArtifactStartMessage(slot, blockRayTraceResult));
                    ArtifactUseContext iuc = new ArtifactUseContext(player.field_70170_p, (PlayerEntity)player, artifact, blockRayTraceResult);
                    ((ArtifactItem)artifact.func_77973_b()).activateArtifact(iuc);
                }
            });
        }
    }

    private static BlockRayTraceResult getBlockRayTraceResult(ClientPlayerEntity player) {
        AxisAlignedBB rayTraceBoundingBox;
        Vector3d eyeVector = player.func_174824_e(1.0f);
        Vector3d lookVector = player.func_70676_i(1.0f);
        Vector3d rayTraceVector = eyeVector.func_72441_c(lookVector.field_72450_a * 30.0, lookVector.field_72448_b * 30.0, lookVector.field_72449_c * 30.0);
        EntityRayTraceResult entityRTR = ProjectileHelper.func_221269_a((World)player.field_70170_p, (Entity)player, (Vector3d)eyeVector, (Vector3d)rayTraceVector, (AxisAlignedBB)(rayTraceBoundingBox = player.func_174813_aQ().func_216361_a(lookVector.func_186678_a(30.0)).func_72314_b(1.0, 1.0, 1.0)), entity -> entity instanceof LivingEntity && !entity.func_175149_v() && entity.func_70067_L());
        if (entityRTR != null) {
            return new BlockRayTraceResult(entityRTR.func_216348_a().func_213303_ch(), Direction.UP, entityRTR.func_216348_a().func_233580_cy_(), false);
        }
        BlockRayTraceResult blockRTR = (BlockRayTraceResult)player.func_213324_a(30.0, 1.0f, false);
        return blockRTR;
    }
}

