/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.integration.curios;

import com.infamous.dungeons_libraries.integration.curios.client.CuriosClientIntegration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod.EventBusSubscriber(modid="dungeons_libraries", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CuriosIntegration {
    public static final String ARTIFACT_IDENTIFIER = "artifact";

    @SubscribeEvent
    public static void enqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(ARTIFACT_IDENTIFIER).icon(CuriosClientIntegration.curiosIconTexture).priority(10).size(3).build());
    }

    public static List<ItemStack> getArtifacts(LivingEntity livingEntity) {
        Optional artifactStackHandler;
        LazyOptional curiosHandler = CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity);
        if (curiosHandler.isPresent() && (artifactStackHandler = ((ICuriosItemHandler)curiosHandler.resolve().get()).getStacksHandler(ARTIFACT_IDENTIFIER)).isPresent()) {
            IDynamicStackHandler stacks = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks();
            ArrayList<ItemStack> artifacts = new ArrayList<ItemStack>();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                artifacts.add(stacks.getStackInSlot(i));
            }
            return artifacts;
        }
        return Collections.emptyList();
    }
}

