/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.entities.elite;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMob;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMobHelper;
import com.infamous.dungeons_libraries.config.DungeonsLibrariesConfig;
import com.infamous.dungeons_libraries.entities.elite.EliteMobConfig;
import com.infamous.dungeons_libraries.entities.elite.EliteMobConfigRegistry;
import com.infamous.dungeons_libraries.network.NetworkHandler;
import com.infamous.dungeons_libraries.network.message.EliteMobMessage;
import java.util.UUID;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class EliteMobEvents {
    public static final float SIZE_ADJUSTMENT = 1.1f;

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        World level = event.getWorld();
        if (!level.func_201670_d() && event.getEntity() instanceof LivingEntity && ((Boolean)DungeonsLibrariesConfig.ENABLE_ELITE_MOBS.get()).booleanValue()) {
            LivingEntity entity = (LivingEntity)event.getEntity();
            EliteMobEvents.makeElite(level, entity);
        }
    }

    public static void makeEliteChance(World level, LivingEntity entity) {
        Chunk chunk;
        EliteMob cap = EliteMobHelper.getEliteMobCapability((Entity)entity);
        if (cap == null) {
            return;
        }
        EliteMobConfig config = EliteMobConfigRegistry.getRandomConfig(entity.func_200600_R().getRegistryName(), entity.func_70681_au());
        if (!cap.hasSpawned() && config != null && (chunk = level.func_72863_F().func_225313_a(entity.func_233580_cy_().func_177958_n() >> 4, entity.func_233580_cy_().func_177952_p() >> 4)) != null && chunk.func_201589_g().func_209003_a(ChunkStatus.field_222617_m) && (double)entity.func_70681_au().nextFloat() < (Double)DungeonsLibrariesConfig.ELITE_MOBS_BASE_CHANCE.get() * (double)level.func_175649_E(entity.func_233580_cy_()).func_180170_c()) {
            EliteMobEvents.makeElite(entity, config);
        }
        cap.setHasSpawned(true);
    }

    public static void makeElite(World level, LivingEntity entity) {
        EliteMob cap = EliteMobHelper.getEliteMobCapability((Entity)entity);
        if (cap == null) {
            return;
        }
        EliteMobConfig config = EliteMobConfigRegistry.getRandomConfig(entity.func_200600_R().getRegistryName(), entity.func_70681_au());
        if (config != null) {
            EliteMobEvents.makeElite(entity, config);
        }
        cap.setHasSpawned(true);
    }

    private static void makeElite(LivingEntity entity, EliteMobConfig config) {
        EliteMob cap = EliteMobHelper.getEliteMobCapability((Entity)entity);
        if (cap == null) {
            return;
        }
        EliteMobEvents.setItemSlot(entity, EquipmentSlotType.HEAD, config.getHeadItem());
        EliteMobEvents.setItemSlot(entity, EquipmentSlotType.CHEST, config.getChestItem());
        EliteMobEvents.setItemSlot(entity, EquipmentSlotType.LEGS, config.getLegsItem());
        EliteMobEvents.setItemSlot(entity, EquipmentSlotType.FEET, config.getFeetItem());
        EliteMobEvents.setItemSlot(entity, EquipmentSlotType.MAINHAND, config.getHandItem());
        EliteMobEvents.setItemSlot(entity, EquipmentSlotType.OFFHAND, config.getOffhandItem());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        config.getAttributes().forEach(attributeModifier -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeModifier.getAttributeResourceLocation());
            if (attribute != null) {
                builder.put((Object)attribute, (Object)new AttributeModifier(UUID.randomUUID(), "Armor modifier", attributeModifier.getAmount(), attributeModifier.getOperation()));
            }
        });
        entity.func_233645_dx_().func_233793_b_((Multimap)builder.build());
        cap.setElite(true);
        cap.setTexture(config.getTexture());
    }

    private static void setItemSlot(LivingEntity entity, EquipmentSlotType slotType, ItemStack item) {
        if (!item.equals(ItemStack.field_190927_a)) {
            entity.func_184201_a(slotType, item);
        }
    }

    @SubscribeEvent
    public static void onEntityEventSize(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        EliteMob cap = EliteMobHelper.getEliteMobCapability(entity);
        if (cap == null) {
            return;
        }
        if (cap.isElite()) {
            float totalWidth = event.getNewSize().field_220315_a * 1.1f;
            float totalHeight = event.getNewSize().field_220316_b * 1.1f;
            event.setNewEyeHeight(event.getNewEyeHeight() * 1.1f);
            event.setNewSize(EntitySize.func_220311_c((float)totalWidth, (float)totalHeight));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLivingEventPre(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity = event.getEntity();
        EliteMob cap = EliteMobHelper.getEliteMobCapability((Entity)entity);
        if (cap == null) {
            return;
        }
        if (cap.isElite()) {
            event.getMatrixStack().func_227860_a_();
            event.getMatrixStack().func_227862_a_(1.1f, 1.1f, 1.1f);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLivingEventPost(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity = event.getEntity();
        EliteMob cap = EliteMobHelper.getEliteMobCapability((Entity)entity);
        if (cap == null) {
            return;
        }
        if (cap.isElite()) {
            event.getMatrixStack().func_227865_b_();
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        PlayerEntity player = event.getPlayer();
        Entity target = event.getTarget();
        if (player instanceof ServerPlayerEntity && target instanceof LivingEntity) {
            EliteMob cap = EliteMobHelper.getEliteMobCapability(event.getTarget());
            if (cap == null) {
                return;
            }
            if (cap.isElite()) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new EliteMobMessage(target.func_145782_y(), cap.isElite(), cap.getTexture()));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingConvert(LivingConversionEvent.Post event) {
        EliteMob cap = EliteMobHelper.getEliteMobCapability(event.getEntity());
        EliteMob outcomeCap = EliteMobHelper.getEliteMobCapability((Entity)event.getOutcome());
        if (cap == null || outcomeCap == null) {
            return;
        }
        outcomeCap.setHasSpawned(true);
        if (cap.isElite()) {
            outcomeCap.setElite(true);
        }
    }
}

