/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.data.util;

import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

public class RegistryDispatcher<DTYPE extends IForgeRegistryEntry<DTYPE>, DISPATCHABLES> {
    private final Supplier<IForgeRegistry<DTYPE>> registryGetter;
    private final Class<DTYPE> registryClass;
    private final Codec<DTYPE> dispatcherCodec;
    private final Codec<DISPATCHABLES> dispatchedCodec;

    public static <DTYPE extends Dispatcher<DTYPE, ? extends DISPATCHABLES>, DISPATCHABLES extends Dispatchable<DTYPE>> RegistryDispatcher<DTYPE, DISPATCHABLES> makeDispatchForgeRegistry(IEventBus modBus, Class<?> registryClass, ResourceLocation registryID, Consumer<RegistryBuilder<DTYPE>> extraSettings) {
        Class<?> genargifiedClass = registryClass;
        RegistryWrapper wrapper = new RegistryWrapper();
        Codec dispatcherCodec = ResourceLocation.field_240908_a_.xmap(id -> (Dispatcher)wrapper.get().getValue(id), ForgeRegistryEntry::getRegistryName);
        Codec dispatchedCodec = dispatcherCodec.dispatch(dispatchable -> (Dispatcher)((Object)((Object)dispatchable.getDispatcher())), dispatcher -> dispatcher.getSubCodec());
        Consumer<RegistryEvent.NewRegistry> newRegistryListener = event -> {
            RegistryBuilder builder = new RegistryBuilder().setName(registryID).setType(genargifiedClass);
            extraSettings.accept(builder);
            IForgeRegistry registry = builder.create();
            wrapper.setRegistry(registry);
        };
        modBus.addListener(newRegistryListener);
        return new RegistryDispatcher(wrapper, genargifiedClass, dispatcherCodec, dispatchedCodec);
    }

    public RegistryDispatcher(Supplier<IForgeRegistry<DTYPE>> registryGetter, Class<DTYPE> registryClass, Codec<DTYPE> dispatcherCodec, Codec<DISPATCHABLES> dispatchedCodec) {
        this.registryGetter = registryGetter;
        this.registryClass = registryClass;
        this.dispatcherCodec = dispatcherCodec;
        this.dispatchedCodec = dispatchedCodec;
    }

    public IForgeRegistry<DTYPE> getForgeRegistry() {
        return this.registryGetter.get();
    }

    public Class<DTYPE> getRegistryClass() {
        return this.registryClass;
    }

    public Codec<DTYPE> getDispatcherCodec() {
        return this.dispatcherCodec;
    }

    public Codec<DISPATCHABLES> getDispatchedCodec() {
        return this.dispatchedCodec;
    }

    public DeferredRegister<DTYPE> makeDeferredRegister(String modid) {
        return DeferredRegister.create(this.getRegistryClass(), (String)modid);
    }

    private static class RegistryWrapper<T extends IForgeRegistryEntry<T>>
    implements Supplier<IForgeRegistry<T>> {
        private IForgeRegistry<T> registry = null;

        private RegistryWrapper() {
        }

        @Override
        public IForgeRegistry<T> get() {
            return this.registry;
        }

        public void setRegistry(IForgeRegistry<T> value) {
            this.registry = value;
        }
    }

    public static abstract class Dispatchable<DTYPE> {
        private final Supplier<? extends DTYPE> dispatcherGetter;

        public DTYPE getDispatcher() {
            return this.dispatcherGetter.get();
        }

        public Dispatchable(Supplier<? extends DTYPE> dispatcherGetter) {
            this.dispatcherGetter = dispatcherGetter;
        }
    }

    public static abstract class Dispatcher<DTYPE extends IForgeRegistryEntry<DTYPE>, P>
    extends ForgeRegistryEntry<DTYPE> {
        private final Codec<P> subCodec;

        public Codec<P> getSubCodec() {
            return this.subCodec;
        }

        public Dispatcher(Codec<P> subCodec) {
            this.subCodec = subCodec;
        }
    }
}

