/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.commands;

import com.infamous.dungeons_libraries.entities.elite.EliteMobEvents;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntitySummonArgument;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SummonEliteCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.summonelite.failed"));
    private static final SimpleCommandExceptionType ERROR_DUPLICATE_UUID = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.summonelite.failed.uuid"));
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.summonelite.invalidPosition"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"summonelite").requires(p_198740_0_ -> p_198740_0_.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entity", (ArgumentType)EntitySummonArgument.func_211366_a()).suggests(SuggestionProviders.field_197505_d).executes(p_198738_0_ -> SummonEliteCommand.spawnEntity((CommandSource)p_198738_0_.getSource(), EntitySummonArgument.func_211368_a((CommandContext)p_198738_0_, (String)"entity"), ((CommandSource)p_198738_0_.getSource()).func_197036_d(), new CompoundNBT(), true))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"pos", (ArgumentType)Vec3Argument.func_197301_a()).executes(p_198735_0_ -> SummonEliteCommand.spawnEntity((CommandSource)p_198735_0_.getSource(), EntitySummonArgument.func_211368_a((CommandContext)p_198735_0_, (String)"entity"), Vec3Argument.func_197300_a((CommandContext)p_198735_0_, (String)"pos"), new CompoundNBT(), true))).then(Commands.func_197056_a((String)"nbt", (ArgumentType)NBTCompoundTagArgument.func_218043_a()).executes(p_198739_0_ -> SummonEliteCommand.spawnEntity((CommandSource)p_198739_0_.getSource(), EntitySummonArgument.func_211368_a((CommandContext)p_198739_0_, (String)"entity"), Vec3Argument.func_197300_a((CommandContext)p_198739_0_, (String)"pos"), NBTCompoundTagArgument.func_218042_a((CommandContext)p_198739_0_, (String)"nbt"), false))))));
    }

    private static int spawnEntity(CommandSource pSource, ResourceLocation pType, Vector3d pPos, CompoundNBT pNbt, boolean pRandomizeProperties) throws CommandSyntaxException {
        BlockPos blockpos = new BlockPos(pPos);
        if (!World.func_234935_k_((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        CompoundNBT compoundnbt = pNbt.func_74737_b();
        compoundnbt.func_74778_a("id", pType.toString());
        ServerWorld serverworld = pSource.func_197023_e();
        Entity entity = EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)serverworld, p_218914_1_ -> {
            p_218914_1_.func_70012_b(pPos.field_72450_a, pPos.field_72448_b, pPos.field_72449_c, p_218914_1_.field_70177_z, p_218914_1_.field_70125_A);
            return p_218914_1_;
        });
        if (entity == null) {
            throw ERROR_FAILED.create();
        }
        if (pRandomizeProperties && entity instanceof MobEntity) {
            ((MobEntity)entity).func_213386_a((IServerWorld)pSource.func_197023_e(), pSource.func_197023_e().func_175649_E(entity.func_233580_cy_()), SpawnReason.COMMAND, (ILivingEntityData)null, (CompoundNBT)null);
        }
        if (entity instanceof LivingEntity) {
            EliteMobEvents.makeElite((World)serverworld, (LivingEntity)entity);
        }
        if (!serverworld.func_242106_g(entity)) {
            throw ERROR_DUPLICATE_UUID.create();
        }
        pSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.summon.success", new Object[]{entity.func_145748_c_()}), true);
        return 1;
    }
}

