/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.commands;

import com.google.common.collect.ImmutableList;
import com.infamous.dungeons_libraries.capabilities.enchantable.EnchantableHelper;
import com.infamous.dungeons_libraries.capabilities.enchantable.IEnchantable;
import com.infamous.dungeons_libraries.commands.arguments.MobEnchantmentArgument;
import com.infamous.dungeons_libraries.mobenchantments.MobEnchantment;
import com.infamous.dungeons_libraries.network.MobEnchantmentMessage;
import com.infamous.dungeons_libraries.network.NetworkHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;

public class MobEnchantmentCommand {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.mobEnchantment.give.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.mobEnchantment.clear.everything.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_SPECIFIC_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.mobEnchantment.clear.specific.failed"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder mobEnchantCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"mobenchantment").requires(commandSource -> commandSource.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"clear").executes(p_198352_0_ -> MobEnchantmentCommand.clearMobEnchantments((CommandSource)p_198352_0_.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSource)p_198352_0_.getSource()).func_197027_g())))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(p_198356_0_ -> MobEnchantmentCommand.clearMobEnchantments((CommandSource)p_198356_0_.getSource(), EntityArgument.func_197097_b((CommandContext)p_198356_0_, (String)"targets")))).then(Commands.func_197056_a((String)"MobEnchantment", (ArgumentType)MobEnchantmentArgument.mobEnchantment()).executes(p_198351_0_ -> MobEnchantmentCommand.removeEnchantment((CommandSource)p_198351_0_.getSource(), EntityArgument.func_197097_b((CommandContext)p_198351_0_, (String)"targets"), MobEnchantmentArgument.getMobEnchantment((CommandContext<CommandSource>)p_198351_0_, "MobEnchantment"))))))).then(Commands.func_197057_a((String)"give").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).then(Commands.func_197056_a((String)"MobEnchantment", (ArgumentType)MobEnchantmentArgument.mobEnchantment()).executes(p_198357_0_ -> MobEnchantmentCommand.addMobEnchantment((CommandSource)p_198357_0_.getSource(), EntityArgument.func_197097_b((CommandContext)p_198357_0_, (String)"targets"), MobEnchantmentArgument.getMobEnchantment((CommandContext<CommandSource>)p_198357_0_, "MobEnchantment"))))));
        dispatcher.register(mobEnchantCommand);
    }

    private static int addMobEnchantment(CommandSource source, Collection<? extends Entity> targets, MobEnchantment mobEnchantment) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            IEnchantable cap;
            if (!(entity instanceof LivingEntity) || (cap = EnchantableHelper.getEnchantableCapability(entity)) == null) continue;
            cap.addEnchantment(mobEnchantment);
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new MobEnchantmentMessage(entity.func_145782_y(), cap.getEnchantments()));
            entity.func_213323_x_();
            ++i;
        }
        if (i == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.MobEnchantment.give.success.single", new Object[]{mobEnchantment.getDisplayName(), targets.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.MobEnchantment.give.success.multiple", new Object[]{mobEnchantment.getDisplayName(), targets.size()}), true);
        }
        return i;
    }

    private static int clearMobEnchantments(CommandSource source, Collection<? extends Entity> targets) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            IEnchantable cap;
            if (!(entity instanceof LivingEntity) || (cap = EnchantableHelper.getEnchantableCapability(entity)) == null) continue;
            cap.clearAllEnchantments();
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new MobEnchantmentMessage(entity.func_145782_y(), cap.getEnchantments()));
            entity.func_213323_x_();
            ++i;
        }
        if (i == 0) {
            throw ERROR_CLEAR_EVERYTHING_FAILED.create();
        }
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.MobEnchantment.clear.everything.success.single", new Object[]{targets.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.MobEnchantment.clear.everything.success.multiple", new Object[]{targets.size()}), true);
        }
        return i;
    }

    private static int removeEnchantment(CommandSource source, Collection<? extends Entity> targets, MobEnchantment mobEnchantment) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            IEnchantable cap;
            if (!(entity instanceof LivingEntity) || (cap = EnchantableHelper.getEnchantableCapability(entity)) == null) continue;
            cap.removeEnchantment(mobEnchantment);
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new MobEnchantmentMessage(entity.func_145782_y(), cap.getEnchantments()));
            entity.func_213323_x_();
            ++i;
        }
        if (i == 0) {
            throw ERROR_CLEAR_SPECIFIC_FAILED.create();
        }
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.MobEnchantment.clear.specific.success.single", new Object[]{mobEnchantment.getDisplayName(), targets.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.MobEnchantment.clear.specific.success.multiple", new Object[]{mobEnchantment.getDisplayName(), targets.size()}), true);
        }
        return i;
    }
}

