/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.client.artifactBar;

import com.infamous.dungeons_libraries.client.gui.elementconfig.GuiElementConfig;
import com.infamous.dungeons_libraries.client.gui.elementconfig.GuiElementConfigRegistry;
import com.infamous.dungeons_libraries.integration.curios.client.CuriosKeyBindings;
import com.infamous.dungeons_libraries.items.ItemTagWrappers;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="dungeons_libraries")
public class ArtifactsBarRender {
    private static final ResourceLocation ARTIFACT_BAR_RESOURCE = new ResourceLocation("dungeons_libraries", "textures/gui/artifact_bar.png");
    public static final int SOUL_LEVEL_COLOR = 1093860;

    @SubscribeEvent
    public static void displyArtifactBar(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && ItemTagWrappers.CURIOS_ARTIFACTS.func_230236_b_().isEmpty()) {
            return;
        }
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR) && mc.func_175606_aa() instanceof PlayerEntity) {
            GuiElementConfig guiElementConfig = GuiElementConfigRegistry.getConfig(new ResourceLocation("dungeons_libraries", "artifact_bar"));
            if (guiElementConfig.isHidden()) {
                return;
            }
            PlayerEntity renderPlayer = (PlayerEntity)mc.func_175606_aa();
            if (renderPlayer == null) {
                return;
            }
            MainWindow sr = event.getWindow();
            int scaledWidth = sr.func_198107_o();
            int scaledHeight = sr.func_198087_p();
            int x = guiElementConfig.getXPosition(scaledWidth);
            int y = guiElementConfig.getYPosition(scaledHeight);
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)renderPlayer).ifPresent(iCuriosItemHandler -> ArtifactsBarRender.renderBar(event.getMatrixStack(), mc, renderPlayer, x, y, iCuriosItemHandler));
            mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        }
    }

    private static void renderBar(MatrixStack matrixStack, Minecraft mc, PlayerEntity renderPlayer, int x, int y, ICuriosItemHandler iCuriosItemHandler) {
        Optional artifactStackHandler = iCuriosItemHandler.getStacksHandler("artifact");
        if (artifactStackHandler.isPresent()) {
            int slots = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getSlots();
            ArtifactsBarRender.renderSlotBg(matrixStack, mc, x, y, slots);
            for (int slot = 0; slot < slots; ++slot) {
                ItemStack artifact = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getStackInSlot(slot);
                if (!artifact.func_190926_b() && artifact.func_77973_b() instanceof ArtifactItem) {
                    int xPos = x + slot * 20 + 3;
                    int yPos = y + 3;
                    ArtifactsBarRender.renderSlot(matrixStack, mc, xPos, yPos, renderPlayer, artifact);
                }
                ArtifactsBarRender.renderSlotKeybind(matrixStack, mc, x, y, slot);
            }
        }
    }

    private static void renderSlot(MatrixStack matrixStack, Minecraft mc, int xPos, int yPos, PlayerEntity renderPlayer, ItemStack artifactStack) {
        if (!artifactStack.func_190926_b()) {
            float f = (float)artifactStack.func_190921_D() - 0.0f;
            if (f > 0.0f) {
                RenderSystem.pushMatrix();
                float f1 = 1.0f + f / 5.0f;
                RenderSystem.translatef((float)(xPos + 8), (float)(yPos + 12), (float)0.0f);
                RenderSystem.scalef((float)(1.0f / f1), (float)((f1 + 1.0f) / 2.0f), (float)1.0f);
                RenderSystem.translatef((float)(-(xPos + 8)), (float)(-(yPos + 12)), (float)0.0f);
            }
            Minecraft.func_71410_x().func_175599_af().func_184391_a((LivingEntity)renderPlayer, artifactStack, xPos, yPos);
            if (f > 0.0f) {
                RenderSystem.popMatrix();
            }
            Minecraft.func_71410_x().func_175599_af().func_175030_a(Minecraft.func_71410_x().field_71466_p, artifactStack, xPos, yPos);
        }
    }

    private static void renderSlotBg(MatrixStack matrixStack, Minecraft mc, int xPos, int yPos, int slots) {
        mc.func_110434_K().func_110577_a(ARTIFACT_BAR_RESOURCE);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)62, (int)22, (int)62, (int)22);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    private static void renderSlotKeybind(MatrixStack matrixStack, Minecraft mc, int x, int y, int slot) {
        KeyBinding keybinding;
        String keybind = "";
        if (slot == 0) {
            keybinding = CuriosKeyBindings.activateArtifact1;
            keybind = ArtifactsBarRender.getString(keybinding);
        } else if (slot == 1) {
            keybinding = CuriosKeyBindings.activateArtifact2;
            keybind = ArtifactsBarRender.getString(keybinding);
        } else if (slot == 2) {
            keybinding = CuriosKeyBindings.activateArtifact3;
            keybind = ArtifactsBarRender.getString(keybinding);
        }
        int keybindWidth = mc.field_71466_p.func_78256_a(keybind);
        int xPosition = x + 1 + slot * 20 + 18 - keybindWidth;
        int yPosition = y + 3;
        AbstractGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)mc.field_71466_p, (String)keybind, (int)xPosition, (int)yPosition, (int)0xFFFFFF);
    }

    private static String getString(KeyBinding keybinding) {
        return keybinding.getKey().func_237520_d_().getString();
    }
}

