/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.client;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.capabilities.soulcaster.ISoulCaster;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterHelper;
import com.infamous.dungeons_libraries.client.gui.elementconfig.GuiElementConfig;
import com.infamous.dungeons_libraries.client.gui.elementconfig.GuiElementConfigRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="dungeons_libraries")
public class SoulBarRender {
    private static final ResourceLocation SOUL_BAR_RESOURCE = new ResourceLocation("dungeons_libraries", "textures/misc/soul_bar.png");
    public static final int SOUL_LEVEL_COLOR = 1093860;

    @SubscribeEvent
    public static void displaySoulBar(RenderGameOverlayEvent.Post event) {
        MatrixStack matrixStack = event.getMatrixStack();
        MainWindow sr = event.getWindow();
        int scaledWidth = sr.func_198107_o();
        int scaledHeight = sr.func_198087_p();
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR) && mc.func_175606_aa() instanceof PlayerEntity) {
            GuiElementConfig guiElementConfig = GuiElementConfigRegistry.getConfig(new ResourceLocation("dungeons_libraries", "soul_bar"));
            if (guiElementConfig.isHidden()) {
                return;
            }
            mc.func_110434_K().func_110577_a(SOUL_BAR_RESOURCE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            PlayerEntity renderPlayer = (PlayerEntity)mc.func_175606_aa();
            if (renderPlayer == null) {
                return;
            }
            ISoulCaster soulCasterCapability = SoulCasterHelper.getSoulCasterCapability((Entity)renderPlayer);
            if (soulCasterCapability == null) {
                return;
            }
            float souls = soulCasterCapability.getSouls();
            double maxSouls = renderPlayer.func_233637_b_((Attribute)AttributeRegistry.SOUL_CAP.get());
            GlStateManager.func_227623_K_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderHelper.func_227780_a_();
            mc.func_213239_aq().func_76320_a("soulBar");
            int xPos = guiElementConfig.getXPosition(scaledWidth);
            int yPos = guiElementConfig.getYPosition(scaledHeight);
            if (souls > 0.0f) {
                int backgroundBarWidth = guiElementConfig.getSizeX();
                int foregroundBarWidth = (int)((double)souls / maxSouls * (double)guiElementConfig.getSizeX());
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)backgroundBarWidth, (int)5, (int)121, (int)10);
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)xPos, (int)yPos, (float)0.0f, (float)5.0f, (int)foregroundBarWidth, (int)5, (int)121, (int)10);
            }
            mc.func_213239_aq().func_76319_b();
            if (souls > 0.0f) {
                mc.func_213239_aq().func_76320_a("soulLevel");
                String soulLevel = "" + souls;
                int baseXPos = xPos + guiElementConfig.getSizeX() / 2 - mc.field_71466_p.func_78256_a(soulLevel) / 2;
                int n = scaledHeight - guiElementConfig.getSizeY();
                mc.field_71466_p.getClass();
                int baseYPos = n - 9;
                mc.field_71466_p.func_238421_b_(matrixStack, soulLevel, (float)(baseXPos + 1), (float)baseYPos, 0);
                mc.field_71466_p.func_238421_b_(matrixStack, soulLevel, (float)(baseXPos - 1), (float)baseYPos, 0);
                mc.field_71466_p.func_238421_b_(matrixStack, soulLevel, (float)baseXPos, (float)(baseYPos + 1), 0);
                mc.field_71466_p.func_238421_b_(matrixStack, soulLevel, (float)baseXPos, (float)(baseYPos - 1), 0);
                mc.field_71466_p.func_238421_b_(matrixStack, soulLevel, (float)baseXPos, (float)baseYPos, 1093860);
                mc.func_213239_aq().func_76319_b();
            }
            mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            RenderHelper.func_74518_a();
            RenderSystem.disableBlend();
        }
    }
}

