/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.timers;

import com.infamous.dungeons_libraries.capabilities.timers.ITimers;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;

public class Timers
implements ITimers {
    private final Map<ResourceLocation, Integer> enchantmentTimers = new HashMap<ResourceLocation, Integer>();

    @Override
    public int getEnchantmentTimer(Enchantment enchantment) {
        return this.enchantmentTimers.computeIfAbsent(enchantment.getRegistryName(), resourceLocation -> -1);
    }

    @Override
    public boolean setEnchantmentTimer(Enchantment enchantment, int value) {
        this.enchantmentTimers.put(enchantment.getRegistryName(), value);
        return true;
    }

    @Override
    public boolean setEnchantmentTimer(ResourceLocation enchantment, int value) {
        this.enchantmentTimers.put(enchantment, value);
        return true;
    }

    @Override
    public boolean tickTimers() {
        this.enchantmentTimers.replaceAll((resourceLocation, integer) -> integer > 0 ? integer - 1 : integer);
        return true;
    }

    @Override
    public Map<ResourceLocation, Integer> getEnchantmentTimers() {
        return this.enchantmentTimers;
    }
}

