/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.playerrewards;

import com.infamous.dungeons_libraries.capabilities.playerrewards.IPlayerRewards;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class PlayerRewards
implements IPlayerRewards {
    private Map<ResourceLocation, Integer> rewards = new HashMap<ResourceLocation, Integer>();

    @Override
    public boolean addPlayerReward(ResourceLocation source) {
        this.rewards.put(source, this.rewards.computeIfAbsent(source, resourceLocation -> 1) + 1);
        return true;
    }

    @Override
    public boolean removePlayerReward(ResourceLocation source) {
        if (!this.rewards.containsKey(source) || this.rewards.get(source) == 0) {
            return true;
        }
        this.rewards.put(source, this.rewards.get(source) - 1);
        return true;
    }

    @Override
    public boolean setPlayerRewards(ResourceLocation source, Integer amount) {
        this.rewards.put(source, amount);
        return true;
    }

    @Override
    public Integer getPlayerRewardAmount(ResourceLocation source) {
        return this.rewards.getOrDefault(source, 0);
    }

    @Override
    public boolean hasPlayerReward(ResourceLocation source) {
        return this.rewards.containsKey(source) && this.rewards.get(source) > 0;
    }

    @Override
    public Map<ResourceLocation, Integer> getAllPlayerRewards() {
        return new HashMap<ResourceLocation, Integer>(this.rewards);
    }

    @Override
    public boolean setPlayerRewards(Map<ResourceLocation, Integer> allPlayerRewards) {
        this.rewards = new HashMap<ResourceLocation, Integer>(allPlayerRewards);
        return true;
    }
}

