/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster;

import com.infamous.dungeons_libraries.capabilities.minionmaster.IMaster;
import com.infamous.dungeons_libraries.capabilities.minionmaster.IMinion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Master;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MasterProvider;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Minion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionProvider;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.MasterHurtByTargetGoal;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.MasterHurtTargetGoal;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.MinionFollowOwnerGoal;
import com.infamous.dungeons_libraries.entities.ai.goal.MeleeAttackGoal;
import com.infamous.dungeons_libraries.mixin.GoalSelectorAccessor;
import com.infamous.dungeons_libraries.mixin.MobEntityInvoker;
import com.infamous.dungeons_libraries.summon.SummonConfig;
import com.infamous.dungeons_libraries.summon.SummonConfigRegistry;
import com.infamous.dungeons_libraries.utils.PetHelper;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraftforge.common.util.LazyOptional;

public class MinionMasterHelper {
    @Nullable
    public static LivingEntity getOwnerForHorse(AbstractHorseEntity horseEntity) {
        try {
            if (horseEntity.func_184780_dh() != null) {
                UUID ownerUniqueId = horseEntity.func_184780_dh();
                return ownerUniqueId == null ? null : horseEntity.field_70170_p.func_217371_b(ownerUniqueId);
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public static boolean isMinionEntity(Entity target) {
        IMinion targetSummonableCap = MinionMasterHelper.getMinionCapability(target);
        if (targetSummonableCap == null) {
            return false;
        }
        return targetSummonableCap.getMaster() != null;
    }

    public static boolean isMinionOf(LivingEntity target, LivingEntity owner) {
        IMinion targetSummonableCap = MinionMasterHelper.getMinionCapability((Entity)target);
        if (targetSummonableCap == null) {
            return false;
        }
        return targetSummonableCap.getMaster() != null && targetSummonableCap.getMaster() == owner;
    }

    @Nullable
    public static LivingEntity getMaster(LivingEntity minionMob) {
        try {
            IMinion minion = MinionMasterHelper.getMinionCapability((Entity)minionMob);
            if (minion == null) {
                return null;
            }
            return minion.getMaster();
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public static IMaster getMasterCapability(Entity entity) {
        LazyOptional lazyCap = entity.getCapability(MasterProvider.MASTER_CAPABILITY);
        return (IMaster)lazyCap.orElse((Object)new Master());
    }

    @Nullable
    public static IMinion getMinionCapability(Entity entity) {
        LazyOptional lazyCap = entity.getCapability(MinionProvider.MINION_CAPABILITY);
        return (IMinion)lazyCap.orElse((Object)new Minion());
    }

    public static void addMinionGoals(MobEntity mobEntity) {
        IMinion minionCap = MinionMasterHelper.getMinionCapability((Entity)mobEntity);
        if (minionCap == null) {
            return;
        }
        if (minionCap.isGoalsAdded()) {
            return;
        }
        if (minionCap.isMinion()) {
            SummonConfig config;
            mobEntity.field_70714_bg.func_75776_a(2, (Goal)new MinionFollowOwnerGoal(mobEntity, 1.5, 24.0f, 3.0f, false));
            MinionMasterHelper.clearGoals(mobEntity.field_70715_bh);
            mobEntity.field_70715_bh.func_75776_a(1, (Goal)new MasterHurtByTargetGoal(mobEntity));
            mobEntity.field_70715_bh.func_75776_a(2, (Goal)new MasterHurtTargetGoal(mobEntity));
            mobEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal(mobEntity, LivingEntity.class, 5, false, false, entityIterator -> entityIterator.getClassification(false).equals((Object)EntityClassification.MONSTER) && PetHelper.canPetAttackEntity((LivingEntity)mobEntity, entityIterator)));
            minionCap.getMaster().getCapability(MasterProvider.MASTER_CAPABILITY).ifPresent(master -> master.addMinion((Entity)mobEntity));
            minionCap.setGoalsAdded(true);
            if (minionCap.isSummon() && (config = SummonConfigRegistry.getConfig(mobEntity.func_200600_R().getRegistryName())).shouldAddAttackGoal()) {
                MinionMasterHelper.addSummonAttackGoal(mobEntity);
            }
        }
    }

    private static void addSummonAttackGoal(MobEntity mobEntity) {
        ModifiableAttributeInstance attribute = mobEntity.func_110148_a(Attributes.field_233823_f_);
        if (attribute == null) {
            return;
        }
        if (attribute.func_111126_e() == 0.0) {
            attribute.func_233767_b_(new AttributeModifier("Summon Attack Damage", 1.0, AttributeModifier.Operation.ADDITION));
        }
        mobEntity.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal(mobEntity, 1.0, true));
    }

    static void removeMinion(LivingEntity entityLiving, IMinion cap) {
        LivingEntity master = cap.getMaster();
        IMaster masterCapability = MinionMasterHelper.getMasterCapability((Entity)master);
        if (masterCapability != null) {
            masterCapability.removeMinion(entityLiving);
        }
        cap.setMaster(null);
        if (entityLiving instanceof MobEntity) {
            MobEntity mobEntity = (MobEntity)entityLiving;
            MinionMasterHelper.clearGoals(mobEntity.field_70714_bg);
            MinionMasterHelper.clearGoals(mobEntity.field_70715_bh);
            cap.setGoalsAdded(false);
            ((MobEntityInvoker)entityLiving).invokeRegisterGoals();
        }
    }

    private static void clearGoals(GoalSelector goalSelector) {
        ArrayList<PrioritizedGoal> prioritizedGoals = new ArrayList<PrioritizedGoal>(((GoalSelectorAccessor)goalSelector).getAvailableGoals());
        prioritizedGoals.forEach(prioritizedGoal -> goalSelector.func_85156_a(prioritizedGoal.func_220772_j()));
    }
}

