/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster;

import com.infamous.dungeons_libraries.capabilities.minionmaster.IMaster;
import com.infamous.dungeons_libraries.capabilities.minionmaster.IMinion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class MinionEvents {
    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        IMinion cap = MinionMasterHelper.getMinionCapability((Entity)event.getEntityLiving());
        if (cap != null && cap.isMinion()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingEntityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entityLiving = event.getEntityLiving();
        if (entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        IMinion cap = MinionMasterHelper.getMinionCapability((Entity)entityLiving);
        if (cap != null && cap.isMinion() && cap.isTemporary()) {
            if (cap.getMinionTimer() > 0) {
                cap.setMinionTimer(cap.getMinionTimer() - 1);
            } else if (cap.revertsOnExpiration()) {
                MinionMasterHelper.removeMinion(entityLiving, cap);
            } else {
                entityLiving.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public static void reAddMinionGoals(EntityJoinWorldEvent event) {
        IMinion minionCapability;
        List<Entity> minions;
        IMaster masterCapability;
        Entity entity = event.getEntity();
        if (!event.getWorld().func_201670_d() && entity instanceof MobEntity) {
            MinionMasterHelper.addMinionGoals((MobEntity)entity);
            masterCapability = MinionMasterHelper.getMasterCapability(entity);
            if (masterCapability != null) {
                minions = masterCapability.getAllMinions();
                for (Entity minion : minions) {
                    if (!(minion instanceof MobEntity) || (minionCapability = MinionMasterHelper.getMinionCapability(minion)) == null) continue;
                    minionCapability.setMaster((LivingEntity)((MobEntity)entity));
                    MinionMasterHelper.addMinionGoals((MobEntity)minion);
                }
            }
        }
        if (!event.getWorld().func_201670_d() && entity instanceof PlayerEntity && (masterCapability = MinionMasterHelper.getMasterCapability(entity)) != null) {
            minions = masterCapability.getAllMinions();
            for (Entity minion : minions) {
                if (!(minion instanceof MobEntity) || (minionCapability = MinionMasterHelper.getMinionCapability(minion)) == null) continue;
                minionCapability.setMaster((LivingEntity)((PlayerEntity)entity));
                MinionMasterHelper.addMinionGoals((MobEntity)minion);
            }
        }
    }

    @SubscribeEvent
    public static void checkSummonedMobIsDead(TickEvent.PlayerTickEvent event) {
        PlayerEntity master = event.player;
        if (event.phase == TickEvent.Phase.START || event.side == LogicalSide.CLIENT) {
            return;
        }
        if (!master.func_70089_S()) {
            return;
        }
        IMaster masterCap = MinionMasterHelper.getMasterCapability((Entity)event.player);
        if (masterCap == null) {
            return;
        }
        MinionEvents.updateAliveList(masterCap);
    }

    @SubscribeEvent
    public static void onMinionDeath(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && MinionMasterHelper.isMinionEntity((Entity)event.getEntityLiving())) {
            LivingEntity livingEntity = event.getEntityLiving();
            IMinion minionCapability = MinionMasterHelper.getMinionCapability((Entity)livingEntity);
            if (minionCapability == null) {
                return;
            }
            LivingEntity summoner = minionCapability.getMaster();
            if (summoner != null) {
                IMaster masterCap = MinionMasterHelper.getMasterCapability((Entity)summoner);
                if (masterCap == null) {
                    return;
                }
                MinionEvents.updateAliveList(masterCap);
            }
        }
    }

    private static void updateAliveList(IMaster masterCap) {
        List<Entity> aliveSummons = masterCap.getSummonedMobs().stream().filter(entity -> entity != null && entity.func_70089_S()).collect(Collectors.toList());
        masterCap.setSummonedMobs(aliveSummons);
        List<Entity> aliveMinions = masterCap.getOtherMinions().stream().filter(entity -> entity != null && entity.func_70089_S()).collect(Collectors.toList());
        masterCap.setOtherMinions(aliveMinions);
    }
}

