/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster;

import com.infamous.dungeons_libraries.capabilities.minionmaster.IMaster;
import com.infamous.dungeons_libraries.summon.SummonConfigRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class Master
implements IMaster {
    private Set<Entity> summonedMobs;
    private List<UUID> summonedMobsUUID = new ArrayList<UUID>();
    private ResourceLocation levelOnLoad;
    private Set<Entity> otherMinions;
    private List<UUID> otherMinionsUUID = new ArrayList<UUID>();

    @Override
    public void copyFrom(IMaster summoner) {
        this.setSummonedMobs(summoner.getSummonedMobs());
    }

    @Override
    public List<Entity> getAllMinions() {
        ArrayList<Entity> minions = new ArrayList<Entity>();
        minions.addAll(this.getSummonedMobs());
        minions.addAll(this.getOtherMinions());
        return minions;
    }

    @Override
    public List<Entity> getSummonedMobs() {
        this.summonedMobs = this.initEntities(this.summonedMobs, this.summonedMobsUUID);
        return new ArrayList<Entity>(this.summonedMobs);
    }

    @Override
    public int getSummonedMobsCost() {
        return this.getSummonedMobs().stream().map(entity -> SummonConfigRegistry.getConfig(entity.func_200600_R().getRegistryName()).getCost()).reduce(0, Integer::sum);
    }

    @Override
    public boolean addSummonedMob(Entity entity) {
        this.summonedMobs = this.initEntities(this.summonedMobs, this.summonedMobsUUID);
        return this.summonedMobs.add(entity);
    }

    @Override
    public void setSummonedMobs(List<Entity> summonedMobs) {
        this.summonedMobs = new HashSet<Entity>(summonedMobs);
    }

    @Override
    public void setSummonedMobsUUID(List<UUID> summonedMobsUUID) {
        this.summonedMobsUUID = summonedMobsUUID;
    }

    @Override
    public void setLevelOnLoad(ResourceLocation levelOnLoad) {
        this.levelOnLoad = levelOnLoad;
    }

    @Override
    public boolean addMinion(Entity entity) {
        this.otherMinions = this.initEntities(this.otherMinions, this.otherMinionsUUID);
        return this.otherMinions.add(entity);
    }

    @Override
    public List<Entity> getOtherMinions() {
        this.otherMinions = this.initEntities(this.otherMinions, this.otherMinionsUUID);
        return new ArrayList<Entity>(this.otherMinions);
    }

    @Override
    public void setOtherMinions(List<Entity> otherMinions) {
        this.otherMinions = new HashSet<Entity>(otherMinions);
    }

    private Set<Entity> initEntities(Set<Entity> entities, List<UUID> entityUUIDs) {
        if (entities != null) {
            return entities;
        }
        if (entityUUIDs != null && this.levelOnLoad != null) {
            if (entityUUIDs.isEmpty()) {
                return new HashSet<Entity>();
            }
            RegistryKey registrykey1 = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)this.levelOnLoad);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerWorld world = server.func_71218_a(registrykey1);
            if (world != null) {
                entities = entityUUIDs.stream().map(arg_0 -> ((ServerWorld)world).func_217461_a(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
            }
        } else {
            return new HashSet<Entity>();
        }
        return entities;
    }

    @Override
    public void removeMinion(LivingEntity entityLiving) {
        this.getOtherMinions().remove(entityLiving);
    }
}

