/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.enchantedprojectile;

import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantmentsHelper;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.IBuiltInEnchantments;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class EnchantedProjectile {
    private List<EnchantmentData> enchantmentDataList = new ArrayList<EnchantmentData>();
    public static final String ENCHANTMENT_DATA_KEY = "EnchantmentData";

    public void setEnchantments(ItemStack itemStack) {
        Map itemStackEnchantmentData = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        IBuiltInEnchantments cap = BuiltInEnchantmentsHelper.getBuiltInEnchantmentsCapability(itemStack);
        Map<Enchantment, Integer> builtInEnchantments = cap.getAllBuiltInEnchantmentDatas().stream().collect(Collectors.groupingBy(enchantmentData -> enchantmentData.field_76302_b, Collectors.summingInt(value -> value.field_76303_c)));
        builtInEnchantments.forEach((enchantment, integer) -> itemStackEnchantmentData.compute(enchantment, (enchantment1, integer1) -> integer1 == null ? integer : integer1 + integer));
        this.enchantmentDataList = itemStackEnchantmentData.entrySet().stream().map(entry -> new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
    }

    public int getEnchantmentLevel(Enchantment enchantment) {
        return this.enchantmentDataList.stream().filter(enchantmentData -> enchantmentData.field_76302_b == enchantment).map(enchantmentData -> enchantmentData.field_76303_c).findFirst().orElse(0);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT enchantmentListnbt = new ListNBT();
        this.enchantmentDataList.forEach(enchantmentData -> {
            CompoundNBT enchantmentDataNBT = new CompoundNBT();
            enchantmentDataNBT.func_74778_a("id", String.valueOf(enchantmentData.field_76302_b.getRegistryName()));
            enchantmentDataNBT.func_74777_a("lvl", (short)enchantmentData.field_76303_c);
            enchantmentListnbt.add((Object)enchantmentDataNBT);
        });
        nbt.func_218657_a(ENCHANTMENT_DATA_KEY, (INBT)enchantmentListnbt);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT tag) {
        Map enchantmentIntegerMap = EnchantmentHelper.func_226652_a_((ListNBT)tag.func_150295_c(ENCHANTMENT_DATA_KEY, 10));
        this.enchantmentDataList = enchantmentIntegerMap.entrySet().stream().map(entry -> new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
    }
}

