/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities;

import com.infamous.dungeons_libraries.capabilities.artifact.ArtifactUsageProvider;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantmentsProvider;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMobProvider;
import com.infamous.dungeons_libraries.capabilities.enchantable.EnchantableHelper;
import com.infamous.dungeons_libraries.capabilities.enchantable.EnchantableProvider;
import com.infamous.dungeons_libraries.capabilities.enchantedprojectile.EnchantedProjectileProvider;
import com.infamous.dungeons_libraries.capabilities.minionmaster.IMaster;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MasterProvider;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionMasterHelper;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionProvider;
import com.infamous.dungeons_libraries.capabilities.playerrewards.IPlayerRewards;
import com.infamous.dungeons_libraries.capabilities.playerrewards.PlayerRewardsHelper;
import com.infamous.dungeons_libraries.capabilities.playerrewards.PlayerRewardsProvider;
import com.infamous.dungeons_libraries.capabilities.soulcaster.ISoulCaster;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterHelper;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterProvider;
import com.infamous.dungeons_libraries.capabilities.timers.TimersProvider;
import com.infamous.dungeons_libraries.config.DungeonsLibrariesConfig;
import com.infamous.dungeons_libraries.network.NetworkHandler;
import com.infamous.dungeons_libraries.network.UpdateSoulsMessage;
import java.util.Arrays;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class CapabilityEvents {
    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("dungeons_libraries", "summonable"), (ICapabilityProvider)new MinionProvider());
            event.addCapability(new ResourceLocation("dungeons_libraries", "summoner"), (ICapabilityProvider)new MasterProvider());
            event.addCapability(new ResourceLocation("dungeons_libraries", "soul_caster"), (ICapabilityProvider)new SoulCasterProvider());
            event.addCapability(new ResourceLocation("dungeons_libraries", "timers"), (ICapabilityProvider)new TimersProvider());
            event.addCapability(new ResourceLocation("dungeons_libraries", "elite_mob"), (ICapabilityProvider)new EliteMobProvider());
        }
        if (EnchantableHelper.isEnchantableEntity((Entity)event.getObject())) {
            event.addCapability(new ResourceLocation("dungeons_libraries", "enchantable"), (ICapabilityProvider)new EnchantableProvider());
        }
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("dungeons_libraries", "artifact_usage"), (ICapabilityProvider)new ArtifactUsageProvider());
        }
        if (event.getObject() instanceof ServerPlayerEntity) {
            event.addCapability(new ResourceLocation("dungeons_libraries", "playerrewards"), (ICapabilityProvider)new PlayerRewardsProvider());
        }
        if (event.getObject() instanceof ProjectileEntity) {
            event.addCapability(new ResourceLocation("dungeons_libraries", "enchanted_projectile"), (ICapabilityProvider)new EnchantedProjectileProvider());
        }
    }

    @SubscribeEvent
    public static void onAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        event.addCapability(new ResourceLocation("dungeons_libraries", "built_in_enchantments"), (ICapabilityProvider)new BuiltInEnchantmentsProvider((ItemStack)event.getObject()));
    }

    private static boolean canBeEnchanted(ItemStack itemStack) {
        return Arrays.stream(EnchantmentType.values()).anyMatch(enchantmentType -> enchantmentType.func_77557_a(itemStack.func_77973_b()));
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getEntity()), (Object)new UpdateSoulsMessage(SoulCasterHelper.getSoulCasterCapability(event.getEntity()).getSouls()));
        }
    }

    @SubscribeEvent
    public static void cloneSummonerCaps(PlayerEvent.Clone event) {
        IMaster oldSummonerCap = MinionMasterHelper.getMasterCapability((Entity)event.getOriginal());
        IMaster newSummonerCap = MinionMasterHelper.getMasterCapability((Entity)event.getPlayer());
        if (oldSummonerCap != null && newSummonerCap != null) {
            newSummonerCap.copyFrom(oldSummonerCap);
        }
        if (!event.isWasDeath() || ((Boolean)DungeonsLibrariesConfig.ENABLE_KEEP_SOULS_ON_DEATH.get()).booleanValue()) {
            ISoulCaster oldSoulsCap = SoulCasterHelper.getSoulCasterCapability((Entity)event.getOriginal());
            ISoulCaster newSoulsCap = SoulCasterHelper.getSoulCasterCapability((Entity)event.getPlayer());
            if (oldSoulsCap != null && newSoulsCap != null) {
                newSoulsCap.setSouls(oldSoulsCap.getSouls(), (LivingEntity)event.getPlayer());
            }
        }
        IPlayerRewards oldPlayerRewardsCap = PlayerRewardsHelper.getPlayerRewardsCapability(event.getOriginal());
        IPlayerRewards newPlayerRewardsCap = PlayerRewardsHelper.getPlayerRewardsCapability(event.getPlayer());
        if (oldPlayerRewardsCap != null && newPlayerRewardsCap != null) {
            newPlayerRewardsCap.setPlayerRewards(oldPlayerRewardsCap.getAllPlayerRewards());
        }
    }
}

