/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.capabilities.artifact.ArtifactUsage;
import com.infamous.dungeons_libraries.capabilities.artifact.ArtifactUsageStorage;
import com.infamous.dungeons_libraries.capabilities.artifact.IArtifactUsage;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantments;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantmentsStorage;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.IBuiltInEnchantments;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMob;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMobStorage;
import com.infamous.dungeons_libraries.capabilities.enchantable.Enchantable;
import com.infamous.dungeons_libraries.capabilities.enchantable.EnchantableStorage;
import com.infamous.dungeons_libraries.capabilities.enchantable.IEnchantable;
import com.infamous.dungeons_libraries.capabilities.enchantedprojectile.EnchantedProjectile;
import com.infamous.dungeons_libraries.capabilities.enchantedprojectile.EnchantedProjectileStorage;
import com.infamous.dungeons_libraries.capabilities.minionmaster.IMaster;
import com.infamous.dungeons_libraries.capabilities.minionmaster.IMinion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Master;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MasterStorage;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Minion;
import com.infamous.dungeons_libraries.capabilities.minionmaster.MinionStorage;
import com.infamous.dungeons_libraries.capabilities.playerrewards.IPlayerRewards;
import com.infamous.dungeons_libraries.capabilities.playerrewards.PlayerRewards;
import com.infamous.dungeons_libraries.capabilities.playerrewards.PlayerRewardsStorage;
import com.infamous.dungeons_libraries.capabilities.soulcaster.ISoulCaster;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCaster;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterStorage;
import com.infamous.dungeons_libraries.capabilities.timers.ITimers;
import com.infamous.dungeons_libraries.capabilities.timers.Timers;
import com.infamous.dungeons_libraries.capabilities.timers.TimersStorage;
import com.infamous.dungeons_libraries.client.gui.elementconfig.GuiElementConfigRegistry;
import com.infamous.dungeons_libraries.client.renderer.ArmorGearRenderer;
import com.infamous.dungeons_libraries.client.renderer.SoulOrbRenderer;
import com.infamous.dungeons_libraries.config.DungeonsLibrariesConfig;
import com.infamous.dungeons_libraries.entities.ModEntityTypes;
import com.infamous.dungeons_libraries.integration.curios.client.CuriosKeyBindings;
import com.infamous.dungeons_libraries.items.ItemTagWrappers;
import com.infamous.dungeons_libraries.items.RangedItemModelProperties;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorGear;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorGearConfigRegistry;
import com.infamous.dungeons_libraries.items.gearconfig.BowGearConfigRegistry;
import com.infamous.dungeons_libraries.items.gearconfig.CrossbowGearConfigRegistry;
import com.infamous.dungeons_libraries.items.gearconfig.MeleeGearConfigRegistry;
import com.infamous.dungeons_libraries.items.materials.armor.ArmorMaterials;
import com.infamous.dungeons_libraries.items.materials.weapon.WeaponMaterials;
import com.infamous.dungeons_libraries.network.NetworkHandler;
import net.minecraft.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;

@Mod(value="dungeons_libraries")
public class DungeonsLibraries {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "dungeons_libraries";

    public DungeonsLibraries() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> GuiElementConfigRegistry::initGuiElementConfigs);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, DungeonsLibrariesConfig.COMMON_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ItemTagWrappers.init();
        AttributeRegistry.ATTRIBUTES.register(modEventBus);
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        ArmorMaterials.setupVanillaMaterials();
        WeaponMaterials.setupVanillaMaterials();
        ArmorGearConfigRegistry.ARMOR_GEAR_CONFIGS.subscribeAsSyncable(NetworkHandler.INSTANCE, ArmorGearConfigRegistry::toPacket);
        MeleeGearConfigRegistry.MELEE_GEAR_CONFIGS.subscribeAsSyncable(NetworkHandler.INSTANCE, MeleeGearConfigRegistry::toPacket);
        BowGearConfigRegistry.BOW_GEAR_CONFIGS.subscribeAsSyncable(NetworkHandler.INSTANCE, BowGearConfigRegistry::toPacket);
        CrossbowGearConfigRegistry.CROSSBOW_GEAR_CONFIGS.subscribeAsSyncable(NetworkHandler.INSTANCE, CrossbowGearConfigRegistry::toPacket);
        WeaponMaterials.WEAPON_MATERIALS.subscribeAsSyncable(NetworkHandler.INSTANCE, WeaponMaterials::toPacket);
        ArmorMaterials.ARMOR_MATERIALS.subscribeAsSyncable(NetworkHandler.INSTANCE, ArmorMaterials::toPacket);
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IMinion.class, (Capability.IStorage)new MinionStorage(), Minion::new);
        CapabilityManager.INSTANCE.register(IMaster.class, (Capability.IStorage)new MasterStorage(), Master::new);
        CapabilityManager.INSTANCE.register(IEnchantable.class, (Capability.IStorage)new EnchantableStorage(), Enchantable::new);
        CapabilityManager.INSTANCE.register(IBuiltInEnchantments.class, (Capability.IStorage)new BuiltInEnchantmentsStorage(), BuiltInEnchantments::new);
        CapabilityManager.INSTANCE.register(ISoulCaster.class, (Capability.IStorage)new SoulCasterStorage(), SoulCaster::new);
        CapabilityManager.INSTANCE.register(ITimers.class, (Capability.IStorage)new TimersStorage(), Timers::new);
        CapabilityManager.INSTANCE.register(IPlayerRewards.class, (Capability.IStorage)new PlayerRewardsStorage(), PlayerRewards::new);
        CapabilityManager.INSTANCE.register(EnchantedProjectile.class, (Capability.IStorage)new EnchantedProjectileStorage(), EnchantedProjectile::new);
        CapabilityManager.INSTANCE.register(EliteMob.class, (Capability.IStorage)new EliteMobStorage(), EliteMob::new);
        CapabilityManager.INSTANCE.register(IArtifactUsage.class, (Capability.IStorage)new ArtifactUsageStorage(), ArtifactUsage::new);
        event.enqueueWork(NetworkHandler::init);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new RangedItemModelProperties());
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.SOUL_ORB.get()), SoulOrbRenderer::new);
        CuriosKeyBindings.setupCuriosKeybindings();
        GeoArmorRenderer.registerArmorRenderer(ArmorGear.class, ArmorGearRenderer::new);
    }
}

