/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.event;

import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.EnsorcReferences;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ensorcellation")
public class ShieldEnchClientEvents {
    private static boolean hadPhalanx;
    private static double modPhalanx;
    private static long timePhalanx;

    private ShieldEnchClientEvents() {
    }

    @SubscribeEvent
    public static void handleFOVUpdateEvent(FOVUpdateEvent event) {
        PlayerEntity entity = event.getEntity();
        ItemStack stack = event.getEntity().func_184607_cu();
        if (stack.func_77973_b().isShield(stack, (LivingEntity)entity)) {
            int encPhalanx = Utils.getItemEnchantmentLevel((Enchantment)EnsorcReferences.PHALANX, (ItemStack)stack);
            if (encPhalanx > 0) {
                modPhalanx = (double)encPhalanx * 1.25 / 2.0;
                hadPhalanx = true;
                timePhalanx = entity.field_70170_p.func_82737_E();
            }
            event.setNewfov((float)MathHelper.clamp((double)((double)event.getNewfov() - modPhalanx), (double)1.0, (double)2.5));
        } else if (hadPhalanx) {
            if (entity.field_70170_p.func_82737_E() - 20L > timePhalanx) {
                hadPhalanx = false;
                modPhalanx = 0.0;
            }
            event.setNewfov((float)MathHelper.clamp((double)((double)event.getNewfov() - modPhalanx), (double)1.0, (double)2.5));
        }
    }
}

