/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.event;

import cofh.ensorcellation.enchantment.override.MendingEnchantmentAlt;
import cofh.ensorcellation.init.EnsorcConfig;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.XpHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class PreservationEvents {
    private PreservationEvents() {
    }

    @SubscribeEvent
    public static void handleAnvilRepairEvent(AnvilRepairEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!EnsorcConfig.enableMendingOverride) {
            return;
        }
        ItemStack left = event.getItemInput();
        ItemStack output = event.getItemResult();
        if (Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_185296_A, (ItemStack)left) <= 0) {
            return;
        }
        if (output.func_77952_i() < left.func_77952_i()) {
            event.setBreakChance(MendingEnchantmentAlt.anvilDamage);
        }
    }

    @SubscribeEvent
    public static void handleAnvilUpdateEvent(AnvilUpdateEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!EnsorcConfig.enableMendingOverride) {
            return;
        }
        ItemStack left = event.getLeft();
        if (Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_185296_A, (ItemStack)left) <= 0) {
            return;
        }
        ItemStack right = event.getRight();
        ItemStack output = left.func_77946_l();
        if (output.func_77984_f() && output.func_77973_b().func_82789_a(left, right)) {
            int matCost;
            int damageLeft = Math.min(output.func_77952_i(), output.func_77958_k() / 4);
            if (damageLeft <= 0) {
                return;
            }
            for (matCost = 0; damageLeft > 0 && matCost < right.func_190916_E(); ++matCost) {
                int durability = output.func_77952_i() - damageLeft;
                output.func_196085_b(durability);
                damageLeft = Math.min(output.func_77952_i(), output.func_77958_k() / 4);
            }
            event.setMaterialCost(matCost);
            event.setOutput(output);
        } else if (output.func_77984_f()) {
            int damageLeft = left.func_77958_k() - left.func_77952_i();
            int damageRight = right.func_77958_k() - right.func_77952_i();
            int damageRepair = damageLeft + damageRight + output.func_77958_k() * 12 / 100;
            int damageOutput = output.func_77958_k() - damageRepair;
            if (damageOutput < 0) {
                damageOutput = 0;
            }
            if (damageOutput < output.func_77952_i()) {
                output.func_196085_b(damageOutput);
            }
            event.setOutput(output);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void handlePickupXpEvent(PlayerXpEvent.PickupXp event) {
        if (event.isCanceled()) {
            return;
        }
        if (!EnsorcConfig.enableMendingOverride) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ExperienceOrbEntity orb = event.getOrb();
        player.field_71090_bL = 2;
        player.func_71001_a((Entity)orb, 1);
        XpHelper.attemptStoreXP((PlayerEntity)player, (ExperienceOrbEntity)orb);
        if (orb.field_70530_e > 0) {
            player.func_195068_e(orb.field_70530_e);
        }
        orb.func_70106_y();
        event.setCanceled(true);
    }
}

